/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLComp;
import JSim.cellml.CMLConnect;
import JSim.cellml.CMLUnit;
import JSim.cellml.CMLVar;
import JSim.cellml.CMLVarGroup;
import JSim.util.ConstContext;
import JSim.util.JSLang;
import JSim.util.Named;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMLDoc {
    protected UnitNList preUnits;
    protected UnitNList sysUnits;
    protected CMLUnit.NList units;
    protected CMLUnit.List seqUnits;
    protected CMLComp.NList comps;
    protected CMLConnect.List connects;
    protected CMLVarGroup.List varGroups;
    protected ConstContext ctxt;

    public CMLDoc(Document doc, UnitNList pu, UnitNList su) throws Xcept {
        CMLVarGroup g;
        int j;
        Object c;
        int i;
        this.preUnits = pu.copy();
        this.sysUnits = su;
        this.units = new CMLUnit.NList();
        this.seqUnits = new CMLUnit.List();
        this.comps = new CMLComp.NList();
        this.connects = new CMLConnect.List();
        this.varGroups = new CMLVarGroup.List(32);
        this.ctxt = new ConstContext(JSLang.lang);
        this.ctxt.unitConst = true;
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("model")) {
            throw new Xcept("CellML file root element must be <model>");
        }
        NodeList nodes = root.getElementsByTagName("units");
        ArrayList uelems = this.scheduleUnits(nodes);
        for (i = 0; i < uelems.size(); ++i) {
            CMLUnit u = new CMLUnit(this, (Element)uelems.get(i));
            this.units.add(u);
            this.seqUnits.add(u);
        }
        nodes = root.getElementsByTagName("component");
        for (i = 0; i < nodes.getLength(); ++i) {
            c = new CMLComp(this, (Element)nodes.item(i));
            this.comps.add((Named)c);
        }
        nodes = root.getElementsByTagName("connection");
        for (i = 0; i < nodes.getLength(); ++i) {
            c = new CMLConnect(this, (Element)nodes.item(i));
            this.connects.add(c);
        }
        for (i = 0; i < this.comps.size(); ++i) {
            CMLComp comp = this.comps.comp(i);
            for (j = 0; j < comp.vars.size(); ++j) {
                CMLVar v = comp.vars.var(j);
                if (v.varGroup != null) continue;
                CMLVarGroup g2 = new CMLVarGroup(this, v);
                this.varGroups.add(g2);
            }
        }
        for (i = 0; i < this.varGroups.size(); ++i) {
            g = this.varGroups.varGroup(i);
            for (j = 0; j < g.varNames.size(); ++j) {
                String gname = g.varNames.str(j);
                boolean found = false;
                for (int k = 0; k < this.varGroups.size(); ++k) {
                    if (i == k) continue;
                    CMLVarGroup g1 = this.varGroups.varGroup(k);
                    if (!g1.varNames.containSame(gname)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                g.mmlName = gname;
                break;
            }
            if (this.isReserved(g.mmlName)) {
                g.mmlName = "was_" + g.mmlName;
            }
            Util.verbose((String)("VarGroup " + g.varNames + " named " + g.mmlName));
        }
        for (i = 0; i < this.varGroups.size(); ++i) {
            g = this.varGroups.varGroup(i);
            g.loadVarDomains();
        }
        boolean working = true;
        while (working) {
            working = false;
            for (int i2 = 0; i2 < this.comps.size(); ++i2) {
                working = working || this.comps.comp(i2).expandLHSDomains();
            }
        }
    }

    private ArrayList scheduleUnits(NodeList nodes) throws Xcept {
        int n = nodes.getLength();
        Element[] unproc = new Element[n];
        for (int i = 0; i < n; ++i) {
            unproc[i] = (Element)nodes.item(i);
        }
        ArrayList<Element> proc = new ArrayList<Element>(n);
        StringList procNames = new StringList(n);
        StringList unprocNames = new StringList();
        boolean working = true;
        while (working && proc.size() < n) {
            working = false;
            unprocNames = new StringList();
            for (int i = 0; i < n; ++i) {
                Element e = unproc[i];
                if (e == null) continue;
                String ename = e.getAttribute("name");
                StringList ereq = this.requiredUnitNames(e);
                if (!procNames.containSame(ereq)) {
                    Util.verbose((String)("postponing unit " + ename));
                    unprocNames.add((Object)ename);
                    continue;
                }
                Util.verbose((String)("scheduling unit " + ename));
                proc.add(e);
                procNames.add((Object)ename);
                unproc[i] = null;
                working = true;
            }
        }
        if (proc.size() < n) {
            throw new Xcept("Circular dependency in unit definitions " + unprocNames);
        }
        return proc;
    }

    private StringList requiredUnitNames(Element elem) {
        StringList subs = new StringList(4);
        NodeList nodes = elem.getElementsByTagName("unit");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String n = e.getAttribute("units");
            try {
                Unit u = this.preUnits.byName(n);
                continue;
            }
            catch (Xcept x) {
                subs.add((Object)n);
            }
        }
        return subs;
    }

    private boolean isReserved(String n) {
        if (n.equals("PI")) {
            return true;
        }
        if (n.length() < 2) {
            return false;
        }
        String n2 = n.substring(0, 2);
        return n2.equalsIgnoreCase("JS");
    }

    protected Unit getUnit(String uname) throws Xcept {
        try {
            return this.preUnits.byName(uname);
        }
        catch (Xcept e) {
            CMLUnit cunit = this.units.unit(uname);
            if (cunit == null) {
                throw new Xcept("Unknown unit: " + uname);
            }
            return cunit.unit();
        }
    }

    public void writeMML(Writer wrt) throws Xcept {
        int i;
        PrintWriter out = new PrintWriter(wrt, true);
        out.println("import nsrunit;");
        out.println("unit conversion on;");
        for (i = 0; i < this.seqUnits.size(); ++i) {
            this.seqUnits.unit(i).writeMML(out);
        }
        out.println("");
        out.println("math main {");
        for (i = 0; i < this.varGroups.size(); ++i) {
            this.varGroups.varGroup(i).writeMML(out);
        }
        for (i = 0; i < this.comps.size(); ++i) {
            this.comps.comp(i).writeMML(out);
        }
        out.println("}");
    }
}

