/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLComp;
import JSim.cellml.CMLVar;
import JSim.cellml.CMLVarGroup;
import JSim.util.CompareExpr;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;

public class CMLEqn
implements DiagInfo {
    private CMLComp comp;
    private CompareExpr eqn;
    protected CMLVar lhsVar;
    protected Expr.List rhsVars;

    protected CMLEqn(CMLComp c, Expr e) throws Xcept {
        this.comp = c;
        if (!(e instanceof CompareExpr)) {
            throw new Xcept((DiagInfo)this.comp, (DiagInfo)this.eqn, "Equation or relation expected");
        }
        this.eqn = (CompareExpr)e;
        Expr lhs = this.eqn.arg(0);
        if (lhs instanceof CMLVar) {
            this.lhsVar = (CMLVar)lhs;
        }
        Expr rhs = this.eqn.arg(1);
        this.rhsVars = new Expr.List(4);
        rhs.addNamedExpr(this.rhsVars);
    }

    protected boolean expandLHSDomains() throws Xcept {
        boolean addany = false;
        if (this.lhsVar == null) {
            return addany;
        }
        CMLVarGroup lhsVG = this.lhsVar.varGroup;
        for (int i = 0; i < this.rhsVars.size(); ++i) {
            if (!(this.rhsVars.expr(i) instanceof CMLVar)) continue;
            CMLVarGroup rhsVG = ((CMLVar)this.rhsVars.expr((int)i)).varGroup;
            boolean add1 = lhsVG.domains.addAll(rhsVG.domains);
            if (rhsVG.isDomain && !lhsVG.domains.contains(rhsVG)) {
                lhsVG.domains.add(rhsVG);
                add1 = true;
            }
            addany = addany || add1;
        }
        if (addany) {
            Util.verbose((String)("expandLHSDomains: " + this.eqn));
        }
        return addany;
    }

    protected void writeMML(PrintWriter out) throws Xcept {
        out.println("\t" + this.eqn.toString((Context)this.comp.doc.ctxt) + ";");
    }

    public String toString() {
        return this.eqn.toString();
    }

    public String diagInfo() {
        return "CellML equation " + this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLEqn> {
        public List() {
            super(16);
        }

        public CMLEqn eqn(int i) {
            return (CMLEqn)this.get(i);
        }

        public boolean hasLHSVar(CMLVar v) {
            for (int i = 0; i < this.size(); ++i) {
                if (v != this.eqn((int)i).lhsVar) continue;
                return true;
            }
            return false;
        }

        protected boolean expandLHSDomains() throws Xcept {
            boolean addany = false;
            for (int i = 0; i < this.size(); ++i) {
                boolean add1 = this.eqn(i).expandLHSDomains();
                addany = addany || add1;
            }
            return addany;
        }
    }
}

