/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLApply;
import JSim.cellml.CMLComp;
import JSim.cellml.CMLVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IfExpr;
import JSim.util.RealConst;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMLMath
implements DiagInfo {
    private CMLComp comp;
    private CMLApply apply;
    protected Expr.List exprs;

    protected CMLMath(CMLComp c, Element elem) throws Xcept {
        this.comp = c;
        Util.verbose((String)"  processing math");
        this.apply = new CMLApply();
        this.exprs = this.makeExprList(elem);
    }

    protected Expr.List makeExprList(Element elem) throws Xcept {
        Expr.List list = new Expr.List(4);
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String n;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || (n = node.getNodeName()).equals("rdf:RDF")) continue;
            Expr expr = this.makeExpr((Element)node);
            list.add((Object)expr);
        }
        return list;
    }

    protected Expr makeExpr(Element elem) throws Xcept {
        String name = elem.getNodeName();
        if (name.equals("apply")) {
            return this.makeApplyExpr(elem);
        }
        if (name.equals("cn")) {
            return this.makeConstExpr(elem);
        }
        if (name.equals("ci")) {
            return this.makeVarExpr(elem);
        }
        if (name.equals("bvar")) {
            return this.makeBVarExpr(elem);
        }
        if (name.equals("piecewise")) {
            return this.makePiecewiseExpr(elem);
        }
        if (name.equals("pi")) {
            return Expr.pi;
        }
        throw new Xcept((DiagInfo)this.comp, "Tag <" + name + "> not supported within <math>");
    }

    private Expr makeApplyExpr(Element elem) throws Xcept {
        NodeList nodes = elem.getChildNodes();
        Node eop = null;
        Expr.List args = new Expr.List(4);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            if (eop == null) {
                eop = (Element)node;
                continue;
            }
            Expr arg = this.makeExpr((Element)node);
            args.add((Object)arg);
        }
        if (eop == null) {
            throw new Xcept((DiagInfo)this.comp, "<apply> tag missing is operator");
        }
        String opname = eop.getNodeName();
        CMLApply.Op op = this.apply.op(opname);
        if (op == null) {
            throw new Xcept((DiagInfo)this, "<apply> operator <" + opname + "> not supported.");
        }
        return op.makeExpr(args);
    }

    private Expr makePiecewiseExpr(Element elem) throws Xcept {
        Expr.List pieces0 = new Expr.List(4);
        Expr.List pieces1 = new Expr.List(4);
        Expr other = null;
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            String name = node.getNodeName();
            if (name.equals("piece")) {
                Expr.List piece = this.makeExprList((Element)node);
                if (piece.size() != 2) {
                    throw new Xcept((DiagInfo)this, "<piece> requires 2 components, " + piece.size() + " found.");
                }
                pieces0.add((Object)piece.expr(0));
                pieces1.add((Object)piece.expr(1));
                continue;
            }
            if (!name.equals("otherwise")) continue;
            if (other != null) {
                throw new Xcept((DiagInfo)this, "Duplicate <otherwise> tag.");
            }
            Expr.List list = this.makeExprList((Element)node);
            if (list.size() != 1) {
                throw new Xcept((DiagInfo)this, "<otherwise> requires 2 components, " + list.size() + " found.");
            }
            other = list.expr(0);
        }
        if (other == null) {
            throw new Xcept((DiagInfo)this, "<piecewise> without <otherwise> not supported.");
        }
        Expr expr = other;
        int ct = pieces0.size();
        for (int i = 0; i < ct; ++i) {
            Expr test = pieces1.expr(ct - 1 - i);
            Expr val = pieces0.expr(ct - 1 - i);
            expr = new IfExpr(test, val, expr);
        }
        return expr;
    }

    private Expr makeBVarExpr(Element elem) throws Xcept {
        NodeList nodes = elem.getElementsByTagName("ci");
        if (nodes.getLength() != 1) {
            throw new Xcept((DiagInfo)this.comp, "<bvar> tag supports only a single <ci> child");
        }
        CMLVar v = (CMLVar)this.makeVarExpr((Element)nodes.item(0));
        return v;
    }

    private Expr makeVarExpr(Element elem) throws Xcept {
        String name = UtilXML.getText((Element)elem);
        if (Util.isBlank((String)name)) {
            throw new Xcept((DiagInfo)this.comp, "Name text missing in <ci> tag.");
        }
        CMLVar var = this.comp.var(name);
        if (var == null) {
            throw new Xcept((DiagInfo)this.comp, "No such variable \"" + name + "\"");
        }
        return var;
    }

    private Expr makeConstExpr(Element elem) throws Xcept {
        String text = UtilXML.getText((Element)elem);
        double f = Util.toDouble((String)text);
        if (Double.isNaN(f)) {
            throw new Xcept((DiagInfo)this, "Illegal numeric constant <" + text + ">");
        }
        String s = elem.getAttribute("cellml:units");
        if (Util.isBlank((String)s)) {
            return Expr.cons((double)f);
        }
        Unit u = this.comp.doc.getUnit(s);
        return new RealConst(f, u);
    }

    public String toString() {
        return "CellML math for " + this.comp.diagInfo();
    }

    public String diagInfo() {
        return this.toString();
    }
}

