/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLComp;
import JSim.cellml.CMLReacRole;
import JSim.cellml.CMLVar;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMLReac
implements DiagInfo {
    protected CMLComp comp;
    protected boolean reversible;
    protected CMLReacRole.List roles;
    protected CMLReacRole rate;

    protected CMLReac(CMLComp c, Element elem) throws Xcept {
        int i;
        this.comp = c;
        Util.verbose((String)"  processing reaction");
        this.reversible = !elem.getAttribute("reversible").equals("no");
        this.roles = new CMLReacRole.List(8);
        NodeList erefs = elem.getElementsByTagName("variable_ref");
        for (i = 0; i < erefs.getLength(); ++i) {
            Element eref = (Element)erefs.item(i);
            String vname = eref.getAttribute("variable");
            CMLVar v = this.comp.vars.var(vname);
            if (v == null) {
                throw new Xcept((DiagInfo)this, "Undefined variable reference " + vname);
            }
            NodeList eroles = eref.getElementsByTagName("role");
            for (int j = 0; j < eroles.getLength(); ++j) {
                CMLReacRole r = new CMLReacRole(this, v, (Element)eroles.item(j));
                this.roles.add(r);
                if (!r.roleName.equals("rate")) continue;
                if (this.rate != null) {
                    throw new Xcept((DiagInfo)this, "Multiple rates not allowed within <reaction>.");
                }
                this.rate = r;
            }
        }
        for (i = 0; i < this.roles.size(); ++i) {
            this.roles.role(i).addMath();
        }
    }

    protected boolean expandLHSDomains() throws Xcept {
        boolean addany = false;
        for (int i = 0; i < this.roles.size(); ++i) {
            addany = addany || this.roles.role((int)i).eqns.expandLHSDomains();
        }
        return addany;
    }

    protected void writeMML(PrintWriter out) throws Xcept {
        for (int i = 0; i < this.roles.size(); ++i) {
            this.roles.role(i).writeMML(out);
        }
    }

    public String toString() {
        return "reaction";
    }

    public String diagInfo() {
        return "CellML reaction in " + this.comp.diagInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLReac> {
        public List() {
            super(4);
        }

        public CMLReac reac(int i) {
            return (CMLReac)this.get(i);
        }
    }
}

