/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.jcode.JPlanWriter;
import JSim.jcode.JSubWriter;
import JSim.mml.Var;
import JSim.plan.DEBlockToolIF;
import JSim.plan.ODEProc;
import JSim.util.Xcept;

public class JODEWriter
extends JSubWriter {
    public JODEWriter(JPlanWriter w) {
        super(w);
    }

    public void writeClass(ODEProc proc) throws Xcept {
        DEBlockToolIF block = proc.block;
        Var.List muVars = block.muVars();
        this.println("// ODE block solving " + (Object)((Object)block.vstate()));
        this.println("public class " + proc.name.toUpperCase() + " extends ODE1Problem {");
        this.println("");
        this.indentIn();
        this.println("// constructor");
        this.println("public " + proc.name.toUpperCase() + "(RTModel m) throws Xcept {");
        this.indentIn();
        this.println("super(m, \"" + proc.name + "\");");
        String line = "setup(" + this.ctxt.vstruct(block.t()) + ", new RTRealNVar[] {";
        for (int i = 0; i < block.nState(); ++i) {
            Var v = block.v(i);
            if (i > 0) {
                line = line + ",";
            }
            line = line + this.ctxt.vstruct(v);
        }
        line = line + "});";
        this.println(line);
        this.indentOut();
        this.println("}");
        this.println("");
        this.writeXCall(proc.name, "void", "evaluate", "double t, double[] u, double[] udot", "t, u, udot", "interruptCheck(t, udot);");
        this.writeXCall(proc.name, "void", "export", "", "", null);
        this.writeLoopDomains(proc.loopDomains(), proc.block.t());
        this.indentOut();
        this.println("}");
    }

    public void write(ODEProc proc) throws Xcept {
        Var v;
        int i;
        DEBlockToolIF block = proc.block;
        Var.List muVars = block.muVars();
        this.println("// evaluate derivs from state vars");
        this.startMethod("void", proc.name + "_evaluate", "(double t, double[] u, double[] udot) throws Xcept", "(t,u,udot)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        for (i = 0; i < block.nState(); ++i) {
            v = block.v(i);
            this.println(this.ctxt.vcache(v) + " = u[" + i + "];");
        }
        this.println("");
        this.writeCalc(proc.calc);
        this.println("");
        for (i = 0; i < block.nState(); ++i) {
            v = block.vt(i);
            this.println("udot[" + i + "] = " + this.ctxt.vcache(v) + ";");
        }
        this.indentOut();
        this.stopMethod();
        this.println("}");
        this.println("");
        this.println("// export t0 vars after solve() call");
        this.println("public void " + proc.name + "_export" + "() throws Xcept {");
        this.indentIn();
        for (i = 0; i < muVars.size(); ++i) {
            v = muVars.var(i);
            if (v == block.t() || block.vstate().contains((Object)v)) continue;
            this.println("set(" + this.ctxt.vstruct(v) + ", " + this.ctxt.vcache(v) + ");");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.println("}");
        this.println("");
        this.indentOut();
    }
}

