/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.aserver.ASModel;
import JSim.jcode.JPlanWriter;
import JSim.jcode.JSubWriter;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.plan.DEBlockToolIF;
import JSim.plan.MultiCalc;
import JSim.plan.PDEProc;
import JSim.util.Context;
import JSim.util.Expr;
import JSim.util.Xcept;

public class JPDEWriter
extends JSubWriter {
    public JPDEWriter(JPlanWriter w) {
        super(w);
    }

    public void writeClass(PDEProc proc) throws Xcept {
        int i;
        DEBlockToolIF block = proc.block;
        this.println("// PDE block solving " + (Object)((Object)block.vstate()));
        this.println("public class " + proc.name.toUpperCase() + " extends PDE1Problem {");
        this.println("");
        this.indentIn();
        int nv = block.nState();
        Var[] varr = new Var[nv];
        Var[] vtarr = new Var[nv];
        Var[] vxarr = new Var[nv];
        Var[] vxtarr = new Var[nv];
        Var[] vxxarr = new Var[nv];
        for (i = 0; i < block.nState(); ++i) {
            Var v = block.v(i);
            Var vt = block.vt(i);
            Var vx = block.vx(i);
            Object vxt = null;
            Var vxx = vx == null ? null : vx.deriv(block.x(), false);
            varr[i] = v;
            vtarr[i] = vt;
            vxarr[i] = vx;
            vxtarr[i] = vxt;
            vxxarr[i] = vxx;
        }
        this.println("// constructor");
        this.println("public " + proc.name.toUpperCase() + "(RTModel m) throws Xcept {");
        this.indentIn();
        this.println("super(m, \"" + proc.name + "\");");
        this.println("setup(" + this.ctxt.vstruct(block.t()) + ", " + this.ctxt.vstruct(block.x()) + ", 0,");
        this.indentIn();
        this.println(this.PDE_vline(varr) + ",");
        this.println(this.PDE_vline(vtarr) + ",");
        this.println(this.PDE_vline(vxarr) + ",");
        this.println(this.PDE_vline(vxtarr) + ",");
        this.println(this.PDE_vline(vxxarr) + ",");
        this.println("null, null);");
        this.indentOut();
        this.indentOut();
        this.println("}");
        this.println("public boolean usesPDESolver(int which) {");
        this.indentIn();
        this.println("switch (which) {");
        for (i = 0; i < ASModel.PDE_Solvers.length; ++i) {
            this.println("case ASModel.PDE_" + ASModel.PDE_Solvers[i] + ": return " + block.usesPDESolver(i) + ";");
        }
        this.println("default: return false;");
        this.println("}");
        this.indentOut();
        this.println("}");
        this.writeXCall(proc.name, "void", "common_LHB", "double t, double[] u, double[] f1, double[] f2, double[] f3", "t, u, f1, f2, f3", null);
        this.writeXCall(proc.name, "void", "common_RHB", "double t, double[] u, double[] f1, double[] f2, double[] f3", "t, u, f1, f2, f3", null);
        if (block.usesPDESolver(0)) {
            this.writeXCall(proc.name, "void", "LSFEA_tstep", "double t, double x, double[] u, double[] ut", "t,x,u,ut", null);
            this.writeXCall(proc.name, "void", "LSFEA_xstep", "double t, double x, double[] u, double[] uxcoef, double[] uxxcoef", "t,x,u,uxcoef,uxxcoef", null);
        }
        if (block.usesPDESolver(1)) {
            this.writeXCall(proc.name, "void", "MacCormack_State", "double t, double x, double[] u, double[] cX, double[] cXX, double[] src", "t, x, u, cX, cXX, src", null);
        }
        if (block.usesPDESolver(2)) {
            this.writeXCall(proc.name, "void", "Toms731_State", "double t, double x, double[] u, double[] ux, double[] C, double[] Q, double[] R", "t,x,u,ux,C,Q,R", null);
            this.writeXCall(proc.name, "void", "Toms731_LHB", "double t, double[] u, double[] ux, double[] BETA, double[] GAMMA", "t, u, ux, BETA, GAMMA", null);
            this.writeXCall(proc.name, "void", "Toms731_RHB", "double t, double[] u, double[] ux, double[] BETA, double[] GAMMA", "t, u, ux, BETA, GAMMA", null);
        }
        this.writeLoopDomains(proc.loopDomains(), proc.block.t());
        this.indentOut();
        this.println("}");
    }

    public String PDE_vline(Var[] vars) {
        String s = "new RTRealNVar[] {";
        for (int i = 0; i < vars.length; ++i) {
            if (i > 0) {
                s = s + ",";
            }
            Var v = vars[i];
            s = s + (v == null ? "null" : this.ctxt.vstruct(v));
        }
        s = s + "}";
        return s;
    }

    public void write(PDEProc proc) throws Xcept {
        DEBlockToolIF block = proc.block;
        this.write_common(proc);
        if (block.usesPDESolver(0)) {
            this.write_LSFEA(proc);
        }
        if (block.usesPDESolver(1)) {
            this.write_MacCormack(proc);
        }
        if (block.usesPDESolver(2)) {
            this.write_Toms731(proc);
        }
    }

    private void write_common(PDEProc proc) throws Xcept {
        this.write_commonBC(true, proc);
        this.write_commonBC(false, proc);
    }

    public void write_commonBC(boolean left, PDEProc proc) throws Xcept {
        DEBlockToolIF block = proc.block;
        this.startMethod("void", proc.name + "_common_" + (left ? "LHB" : "RHB"), "(double t, double[] u, double[] f1, double[] f2, double[] f3) throws Xcept", "(t, u, f1, f2, f3)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        RealNVar xaux = left ? block.x().vmin : block.x().vmax;
        this.println(this.ctxt.vcache(block.x()) + " = " + xaux.toString(this.ctxt) + ";");
        for (int i = 0; i < block.nState(); ++i) {
            this.println(this.ctxt.vcache(block.v(i)) + " = u[" + i + "];");
        }
        MultiCalc calc = left ? proc.lcalc : proc.rcalc;
        this.writeCalc(calc);
        for (int i = 0; i < block.nState(); ++i) {
            Expr expr = block.coefF1(i, left);
            this.println("f1[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
            expr = block.coefF2(i, left);
            this.println("f2[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
            expr = block.coefF3(i, left);
            this.println("f3[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.stopMethod();
        this.println("}");
    }

    private void write_LSFEA(PDEProc proc) throws Xcept {
        Expr expr;
        Var v;
        int i;
        DEBlockToolIF block = proc.block;
        this.println("");
        this.startMethod("void", proc.name + "_LSFEA_tstep", "(double t, double x, double[] u, double[] ut) throws Xcept", "(t,x,u,ut)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        this.println(this.ctxt.vcache(block.x()) + " = x;");
        for (i = 0; i < block.nState(); ++i) {
            v = block.v(i);
            this.println(this.ctxt.vcache(v) + " = u[" + i + "];");
        }
        this.ctxt.muStepDomain = block.x();
        this.writeCalc(proc.ecalc);
        for (i = 0; i < block.nState(); ++i) {
            expr = block.coefS(i);
            this.println("ut[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.stopMethod();
        this.println("}");
        this.println("");
        this.startMethod("void", proc.name + "_LSFEA_xstep", "(double t, double x, double[] u, double[] uxcoef, double[] uxxcoef) throws Xcept", "(t,x,u,uxcoef,uxxcoef)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        this.println(this.ctxt.vcache(block.x()) + " = x;");
        for (i = 0; i < block.nState(); ++i) {
            v = block.v(i);
            this.println(this.ctxt.vcache(v) + " = u[" + i + "];");
        }
        for (i = 0; i < block.nState(); ++i) {
            expr = block.coefB(i);
            this.println("uxcoef[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
            expr = block.coefD(i);
            this.println("uxxcoef[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
        }
        this.ctxt.muStepDomain = block.x();
        this.writeInterruptCheck();
        this.indentOut();
        this.stopMethod();
        this.println("}");
        this.println("");
    }

    private void write_MacCormack(PDEProc proc) throws Xcept {
        int i;
        DEBlockToolIF block = proc.block;
        this.println("");
        this.startMethod("void", proc.name + "_MacCormack_State", "(double t, double x, double[] u, double[] cX, double[] cXX, double[] src) throws Xcept", "(t, x, u, cX, cXX, src)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        this.println(this.ctxt.vcache(block.x()) + " = x;");
        for (i = 0; i < block.nState(); ++i) {
            this.println(this.ctxt.vcache(block.v(i)) + " = u[" + i + "];");
        }
        this.ctxt.muStepDomain = block.x();
        this.writeCalc(proc.ecalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("cX[" + i + "]=" + block.coefB(i).toString((Context)this.ctxt) + ";");
            this.println("cXX[" + i + "]=" + block.coefD(i).toString((Context)this.ctxt) + ";");
            this.println("src[" + i + "]=" + block.coefS(i).toString((Context)this.ctxt) + ";");
        }
        this.ctxt.muStepDomain = null;
        this.writeInterruptCheck();
        this.indentOut();
        this.stopMethod();
        this.println("}");
    }

    private void write_Toms731(PDEProc proc) throws Xcept {
        int i;
        DEBlockToolIF block = proc.block;
        this.println("");
        this.startMethod("void", proc.name + "_Toms731_State", "(double t, double x, double[] u, double[] ux, double[] C, double[] Q, double[] R) throws Xcept", "(t,x,u,ux,C,Q,R)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        this.println(this.ctxt.vcache(block.x()) + " = x;");
        for (i = 0; i < block.nState(); ++i) {
            this.println(this.ctxt.vcache(block.v(i)) + " = u[" + i + "];");
            this.println(this.ctxt.vcache(block.vx(i)) + " = ux[" + i + "];");
        }
        this.ctxt.muStepDomain = block.x();
        this.writeCalc(proc.ecalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("C[" + i + "]=" + block.toms731_C(i).toString((Context)this.ctxt) + ";");
            this.println("Q[" + i + "]=" + block.toms731_Q(i).toString((Context)this.ctxt) + ";");
            this.println("R[" + i + "]=" + block.toms731_R(i).toString((Context)this.ctxt) + ";");
        }
        this.ctxt.muStepDomain = null;
        this.writeInterruptCheck();
        this.indentOut();
        this.stopMethod();
        this.println("}");
        this.write_Toms731BC(true, proc);
        this.write_Toms731BC(false, proc);
    }

    public void write_Toms731BC(boolean left, PDEProc proc) throws Xcept {
        DEBlockToolIF block = proc.block;
        this.startMethod("void", proc.name + "_Toms731_" + (left ? "LHB" : "RHB"), "(double t, double[] u, double[] ux, double[] BETA, double[] GAMMA) throws Xcept", "(t, u, ux, BETA, GAMMA)", true);
        this.indentIn();
        this.println(this.ctxt.vcache(block.t()) + " = t;");
        RealNVar xaux = left ? block.x().vmin : block.x().vmax;
        this.println(this.ctxt.vcache(block.x()) + " = " + xaux.toString(this.ctxt) + ";");
        for (int i = 0; i < block.nState(); ++i) {
            this.println(this.ctxt.vcache(block.v(i)) + " = u[" + i + "];");
            this.println(this.ctxt.vcache(block.vx(i)) + " = ux[" + i + "];");
        }
        MultiCalc calc = left ? proc.lcalc : proc.rcalc;
        this.writeCalc(calc);
        for (int i = 0; i < block.nState(); ++i) {
            Expr expr = block.toms731_BETA(i, left);
            this.println("BETA[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
            expr = block.toms731_GAMMA(i, left);
            this.println("GAMMA[" + i + "]=" + expr.toString((Context)this.ctxt) + ";");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.stopMethod();
        this.println("}");
    }
}

