/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.jcode.JContext;
import JSim.jcode.JPlanWriter;
import JSim.mml.Domain;
import JSim.plan.Cache;
import JSim.plan.Calc;
import JSim.plan.Proc;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;

public class JSubWriter {
    protected JPlanWriter wrt;
    protected JContext ctxt;

    public JSubWriter(JPlanWriter w) {
        this.wrt = w;
        this.ctxt = this.wrt.ctxt;
    }

    public void println(String s) {
        this.wrt.println(s);
    }

    public void writeProc(Proc proc) throws Xcept {
        this.wrt.writeProc(proc);
    }

    public void writeCalc(Calc calc) throws Xcept {
        this.wrt.writeCalc(calc);
    }

    public void writeInterruptCheck() throws Xcept {
        this.wrt.writeInterruptCheck();
    }

    public void indentIn() {
        this.wrt.indentIn();
    }

    public void indentOut() {
        this.wrt.indentOut();
    }

    public void startMethod(String d, String b, String da, String ca, boolean p) {
        this.wrt.startMethod(d, b, da, ca, p);
    }

    public void stopMethod() {
        this.wrt.stopMethod();
    }

    public void writeXCall(String proc, String typ, String meth, String inArgs, String outArgs, String extraLine) throws Xcept {
        this.println("public " + typ + " " + meth + "(RTContext ctxt" + (Util.isBlank((String)inArgs) ? "" : ", " + inArgs) + ") throws Xcept {");
        this.indentIn();
        this.println("((XContext) ctxt)." + proc + "_" + meth + "(" + outArgs + ");");
        if (!Util.isBlank((String)extraLine)) {
            this.println(extraLine);
        }
        this.indentOut();
        this.println("}");
    }

    public void writeLoopDomains(Domain.List doms, Domain t) {
        if (doms == null) {
            return;
        }
        if (t != null) {
            doms.sub((Expr)t);
        }
        if (doms.size() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("public RTRealDomain[] loopDomains() { ");
        buf.append("return new RTRealDomain[] {");
        for (int i = 0; i < doms.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.ctxt.vstruct(doms.var(i)));
        }
        buf.append("}; }");
        this.println("// multiple passes through this solver");
        this.println(buf.toString());
        this.println("");
    }

    public Cache cache() {
        return this.wrt.cache;
    }
}

