/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.OptimResults;
import JSim.data.SensMatrix;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTProblem;
import JSim.nml.Solver;
import JSim.nml.fzero.Fzero2Callbacks;
import JSim.nml.fzero.Fzero2Solver;
import JSim.util.Xcept;

public abstract class Fzero2Problem
extends RTProblem
implements Fzero2Callbacks {
    public int n;

    public Fzero2Problem(RTModel m, String na, int nn) throws Xcept {
        super(m, na);
        this.n = nn;
    }

    public Solver createSolver(int solverInx, RTContext ctxt) throws Xcept {
        return new Fzero2Solver(this, solverInx, ctxt, this.n, this.model.optimFactory());
    }

    public void solve(RTContext ctxt) throws Xcept {
        this.init(ctxt);
        double[] vmin = new double[this.n * this.n];
        double[] vmax = new double[this.n];
        double[] vguess = new double[this.n];
        double[] vfinal = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            vmin[i] = Double.NaN;
            vmax[i] = Double.NaN;
            vguess[i] = Double.NaN;
            vfinal[i] = Double.NaN;
        }
        this.setBounds(ctxt, vmin, vmax, vguess);
        Fzero2Solver solver = (Fzero2Solver)this.solver(ctxt);
        solver.solve(ctxt, this, vguess, vmin, vmax, vfinal);
        this.export(ctxt, vfinal);
    }

    public String desc() {
        return "non-linear zero finder";
    }

    public abstract void setBounds(RTContext var1, double[] var2, double[] var3, double[] var4) throws Xcept;

    public abstract void export(RTContext var1, double[] var2) throws Xcept;

    public abstract void calcZero(RTContext var1, double[] var2, double[] var3) throws Xcept;

    public double calcError(RTContext ctxt, double[] x, OptimResults results) throws Xcept {
        double[] zeroes = new double[this.n];
        this.calcZero(ctxt, x, zeroes);
        double tot = 0.0;
        for (int i = 0; i < this.n; ++i) {
            tot += zeroes[i] * zeroes[i];
        }
        tot = Math.sqrt(tot);
        results.addResult(tot /= (double)this.n, x);
        return tot;
    }

    public int calcErrors(RTContext ctxt, double[][] x, double[] errs, OptimResults results) throws Xcept {
        for (int i = 0; i < errs.length; ++i) {
            errs[i] = this.calcError(ctxt, x[i], results);
            if (!(errs[i] < results.args.errTol)) continue;
            return i + 1;
        }
        return errs.length;
    }

    public SensMatrix calcSensMatrix(RTContext ctxt, double[] x, double[] dx, double[] errs, OptimResults res) throws Xcept {
        throw new Xcept("Fzero2Problem.calcSensMatrix() not implemented");
    }
}

