/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTProblem;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.nml.Solver;
import JSim.nml.ode1.ODE1Callbacks;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public abstract class ODE1Problem
extends RTProblem
implements ODE1Callbacks {
    protected int n;
    protected RTRealDomain t;
    protected RTRealNVar[] vstate;

    public ODE1Problem(RTModel m, String n) throws Xcept {
        super(m, n);
    }

    public void setup(RTRealDomain tt, RTRealNVar[] vv) throws Xcept {
        this.n = vv.length;
        this.t = tt;
        this.vstate = vv;
    }

    public Solver createSolver(int solverInx, RTContext ctxt) throws Xcept {
        return new ODE1Solver(this, solverInx, ctxt, this.n);
    }

    public void solve(RTContext ctxt) throws Xcept {
        this.init(ctxt);
        double[] u0 = new double[this.n];
        double[] uf = new double[this.n];
        double[] udot0 = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            u0[i] = Double.NaN;
            uf[i] = Double.NaN;
            udot0[i] = Double.NaN;
        }
        ODE1Solver solver = (ODE1Solver)this.solver(ctxt);
        for (int i = 0; i < this.vstate.length; ++i) {
            u0[i] = ctxt.realVal(this.vstate[i]);
        }
        if (ctxt.atRHBC(this.t)) {
            this.evaluate(ctxt, ctxt.realVal(this.t), u0, udot0);
            this.export(ctxt);
        } else {
            double t0 = ctxt.realVal(this.t);
            double tf = t0 + ctxt.delta(this.t);
            solver.solve(ctxt, t0, tf, u0, uf);
            this.export(ctxt);
            ctxt.moveRight(this.t);
            for (int i = 0; i < this.vstate.length; ++i) {
                ctxt.set(this.vstate[i], uf[i]);
            }
            this.evaluate(ctxt, ctxt.realVal(this.t), uf, udot0);
            this.export(ctxt);
            ctxt.moveLeft(this.t);
        }
    }

    public void interruptCheck(double t, double[] ut) throws Xcept {
        if (Double.isNaN(t) || this.model.cancelRun) {
            for (int i = 0; i < ut.length; ++i) {
                ut[i] = Double.NaN;
            }
            if (Double.isNaN(t)) {
                throw new Xcept("ODE evaluation aborted: t=NaN");
            }
        }
        super.interruptCheck();
    }

    public abstract void evaluate(RTContext var1, double var2, double[] var4, double[] var5) throws Xcept;

    public abstract void export(RTContext var1) throws Xcept;

    public String desc() {
        return "ODE solver";
    }

    public RTRealNVar[] getStatevars() {
        return this.vstate;
    }
}

