/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.Data;
import JSim.data.GridData;
import JSim.data.NamedVal;
import JSim.data.RealNData;
import JSim.fgen.FgenContext;
import JSim.jruntime.RTDataStore;
import JSim.jruntime.RTIntNVar;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.jruntime.RTVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.JSLang;
import JSim.util.MPDispatch;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.Xcept;

public class RTContext
extends FgenContext
implements NamedVal.Query {
    public RTModel model;
    public int threadInx;
    private int nproc;
    public RTDataStore store;
    private boolean isQuery;
    private int[] state;
    private static int UNSET = -1;
    public static final int TRACE = 1;
    public static final int TRACENAN = 2;
    public static final int ABORTNAN = 4;

    public RTContext(RTModel m, int thread, int np, RTDataStore s, boolean q) {
        super(JSLang.lang);
        this.model = m;
        this.threadInx = thread;
        this.nproc = np;
        this.store = s;
        this.isQuery = q;
        this.state = new int[this.model.domains.size()];
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = UNSET;
        }
    }

    public RTContext(RTContext ctxt, RTDataStore s) {
        super(JSLang.lang);
        this.model = ctxt.model;
        this.threadInx = ctxt.threadInx;
        this.nproc = 1;
        this.store = s;
        this.isQuery = ctxt.isQuery;
        this.state = (int[])ctxt.state.clone();
    }

    protected void interruptCheck() throws Xcept {
        this.model.interruptCheck();
    }

    public RTDataStore store() {
        return this.store;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public String newName(Named n) {
        return n.name();
    }

    public String funcCall(Named n, Expr.List elist) {
        return n.name() + elist.toString((Context)this);
    }

    public NamedExpr domain(String n) throws Xcept {
        RTVar v = this.model.getVar(n);
        if (!v.isDomain()) {
            throw new Xcept((DiagInfo)v, "Variable is not domain as required");
        }
        return v;
    }

    public GridData gdata(NamedExpr x) throws Xcept {
        return this.grid((RTRealDomain)x);
    }

    public NamedVal namedVal(String n) throws Xcept {
        return this.store.namedVal(n);
    }

    public GridData grid(RTRealDomain x) throws Xcept {
        GridData grid = this.store.gdata(x);
        if (grid == null) {
            throw new Xcept((DiagInfo)x, "Data grid not yet available");
        }
        return grid;
    }

    public int ct(RTRealDomain x) throws Xcept {
        return this.grid(x).ct();
    }

    public double delta(RTRealDomain x) throws Xcept {
        return x.vdelta.realVal((Context)this);
    }

    public double realVal(RTRealDomain x) throws Xcept {
        return this.grid(x).realVal(this.inx(x));
    }

    public int getState(RTRealDomain x) throws Xcept {
        return this.state[x.domainID()];
    }

    public int inx(RTRealDomain x) throws Xcept {
        int inx = this.state[x.domainID()];
        if (inx < 0) {
            throw new Xcept((DiagInfo)x, "Domain index not set");
        }
        return inx;
    }

    public boolean atLHBC(RTRealDomain x) throws Xcept {
        return this.getState(x) == 0;
    }

    public boolean atRHBC(RTRealDomain x) throws Xcept {
        return this.inx(x) == this.ct(x) - 1;
    }

    public boolean isSet(RTRealDomain x) throws Xcept {
        return this.getState(x) >= 0;
    }

    public void setState(RTRealDomain x, int i) throws Xcept {
        if (i >= 0) {
            GridData gdata = this.store.gdata(x);
            if (gdata == null) {
                throw new Xcept((DiagInfo)x, "Domain setState() with null grid");
            }
            if (i >= gdata.ct()) {
                throw new Xcept((DiagInfo)x, "Domain index out of bounds (" + i + ")");
            }
            this.state[x.domainID()] = i;
        } else {
            this.state[x.domainID()] = UNSET;
        }
    }

    public void setInx(RTRealDomain x, int i) throws Xcept {
        if (i < 0) {
            throw new Xcept((DiagInfo)x, "Negative domain index is invalid");
        }
        this.setState(x, i);
    }

    public void unSet(RTRealDomain x) throws Xcept {
        this.state[x.domainID()] = UNSET;
    }

    public void setLHBC(RTRealDomain x) throws Xcept {
        this.setState(x, 0);
    }

    public void setRHBC(RTRealDomain x) throws Xcept {
        this.setInx(x, this.ct(x) - 1);
    }

    public void moveRight(RTRealDomain x) throws Xcept {
        GridData grid = this.store.gdata(x);
        int id = x.domainID();
        int was = this.state[id];
        if (this.state[id] < grid.ct() - 1) {
            int n = id;
            this.state[n] = this.state[n] + 1;
        } else {
            this.state[id] = UNSET;
        }
    }

    public void moveLeft(RTRealDomain x) throws Xcept {
        int id = x.domainID();
        if (this.state[id] > 0) {
            int n = id;
            this.state[n] = this.state[n] - 1;
        } else {
            this.state[id] = UNSET;
        }
    }

    public int inx(RTRealNVar v) throws Xcept {
        switch (v.ndim()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.inx(v.doms[0]);
            }
        }
        int[] pos = new int[v.ndim()];
        int[] ct = new int[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = this.inx(v.doms[i]);
            ct[i] = this.ct(v.doms[i]);
        }
        return Data.inx((int[])pos, (int[])ct);
    }

    public RealNData ndata(RTRealNVar v) throws Xcept {
        RealNData ndata = this.store.ndata(v);
        if (ndata == null) {
            ndata = v.makeData(this);
            this.store.setData(v, (Data)ndata);
        }
        return ndata;
    }

    public double realVal(RTRealNVar v) throws Xcept {
        this.calcAssign(v);
        RealNData ndata = this.store.ndata(v);
        double val = ndata.realVal(this.inx(v));
        if (v instanceof RTIntNVar) {
            val = Math.floor(val);
        }
        return val;
    }

    public double realVal(RTRealNVar v, double[] vals) throws Xcept {
        this.calcAssign(v);
        RealNData ndata = this.store.ndata(v);
        double val = ndata.realVal(vals);
        if (v instanceof RTIntNVar) {
            val = Math.floor(val);
        }
        return val;
    }

    public int intVal(RTRealNVar v) throws Xcept {
        return (int)this.realVal(v);
    }

    protected void calcAssign(RTVar v) throws Xcept {
        this.store.calcAssign(this, v);
    }

    public void set(RTRealNVar v, double val) throws Xcept {
        RealNData ndata = this.store.ndata(v);
        if (ndata == null) {
            ndata = v.makeData(this);
            this.store.setData(v, (Data)ndata);
        }
        if (v instanceof RTIntNVar) {
            val = Math.floor(val);
        }
        ndata.set(this.inx(v), val);
    }

    public void startPhase(int i, RTRealDomain x) {
        this.store.startPhase(i, x);
    }

    public void updatePhase(double frac) {
        this.store.updatePhase(frac);
    }

    public final void trace(int action, RTRealNVar v, double val) throws Xcept {
        if (this.doAbort(action, val)) {
            throw new Xcept(this.traceCacheMsg(v, val));
        }
        if (this.doTrace(action, val)) {
            System.err.println(this.traceCacheMsg(v, val));
        }
    }

    private final String traceCacheMsg(RTRealNVar v, double val) {
        return v.name + "()=" + val;
    }

    public final void setTrace(int action, RTRealNVar v, double val) throws Xcept {
        this.set(v, val);
        if (this.doAbort(action, val)) {
            throw new Xcept(this.traceArrayMsg(v, val));
        }
        if (this.doTrace(action, val)) {
            System.err.println(this.traceArrayMsg(v, val));
        }
    }

    private final String traceArrayMsg(RTRealNVar v, double val) throws Xcept {
        return v.name + "[" + this.inx(v) + "]=" + val;
    }

    private final boolean doAbort(int action, double val) {
        return (action & 4) > 0 && Double.isNaN(val);
    }

    private final boolean doTrace(int action, double val) {
        if ((action & 1) > 0) {
            return true;
        }
        return (action & 2) > 0 && Double.isNaN(val);
    }

    public void calcGroup(int gcode) throws Xcept {
        int wproc;
        int ct = this.calcGroupSize(gcode);
        if (ct < 2 || this.nproc < 2 || !this.calcGroupParallel(gcode)) {
            this.calcGroup(gcode, 0, ct);
            return;
        }
        int niters = ct / this.nproc;
        if (niters * this.nproc < ct) {
            ++niters;
        }
        if ((wproc = ct / niters) * niters < ct) {
            ++wproc;
        }
        MPDispatch.Job[] jobs = new MPDispatch.Job[wproc];
        for (int i = 0; i < wproc; ++i) {
            int fromIter = i * niters;
            int toIter = (i + 1) * niters;
            if (toIter > ct) {
                toIter = ct;
            }
            jobs[i] = new CalcGroupJob(this, gcode, fromIter, toIter);
        }
        MPDispatch dispatch = new MPDispatch("GroupCalcDispatch " + gcode, jobs, null);
        dispatch.run(wproc);
    }

    public void calcGroupInit(RTContext ctxt, int gcode) throws Xcept {
        this.state = (int[])ctxt.state.clone();
    }

    public boolean calcGroupParallel(int gcode) {
        return false;
    }

    public int calcGroupSize(int gcode) throws Xcept {
        throw new Xcept("Illegal groupCode=" + gcode);
    }

    public void calcGroup(int gcode, int fromItem, int toIter) throws Xcept {
        throw new Xcept("Illegal groupCode=" + gcode);
    }

    public static class CalcGroupJob
    implements MPDispatch.Job {
        public RTContext pctxt;
        public int gcode;
        public int fromIter;
        public int toIter;

        public CalcGroupJob(RTContext p, int g, int f, int t) {
            this.pctxt = p;
            this.gcode = g;
            this.fromIter = f;
            this.toIter = t;
        }

        public String jobName() {
            return "CalcGroupJob " + this.gcode + "(" + this.fromIter + "-" + this.toIter + ")";
        }

        public void jobCancel() {
        }

        public void jobRunX(int workerInx) throws Xcept {
            int threadInx = this.pctxt.threadInx + workerInx;
            RTContext ctxt = this.pctxt.model.newRunContext(threadInx, 1, this.pctxt.store);
            ctxt.calcGroupInit(this.pctxt, this.gcode);
            ctxt.calcGroup(this.gcode, this.fromIter, this.toIter);
        }
    }
}

