/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.aserver.ASInfo;
import JSim.data.Data;
import JSim.data.GridData;
import JSim.data.NamedVal;
import JSim.data.RealNData;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTLiveQuery;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.jruntime.RTVar;
import JSim.util.ConstExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;

public final class RTDataStore
implements NamedVal.Query {
    private RTModel model;
    private String name;
    private String sensP;
    private double sensDelta;
    private Data[] data;
    private boolean[] assignPending;
    private NamedVal.NList overrides;
    private boolean isRunning;
    private RTContext runCtxt;
    private RTLiveQuery.List liveQueries;
    private ASInfo.RunStatus runStat;
    private RTRealDomain runDomain;

    public RTDataStore(RTModel m) {
        this.model = m;
        this.sensDelta = Double.NaN;
        this.clear();
    }

    public void clear() {
        this.data = new Data[this.model.vars.size()];
        this.assignPending = new boolean[this.model.vars.size()];
        for (int i = 0; i < this.assignPending.length; ++i) {
            if (!this.model.vars.var(i).isInput()) continue;
            this.assignPending[i] = true;
        }
        this.overrides = null;
        this.liveQueries = new RTLiveQuery.List();
    }

    protected void setName(String n) {
        this.name = n;
    }

    protected void setSens(String p, double delta) {
        this.sensP = p;
        this.sensDelta = delta;
    }

    protected void setData(RTVar v, Data d) {
        d.setGroup(this.name);
        this.data[v.varID()] = d;
    }

    protected void runPrep(RTContext ctxt, NamedVal.NList overs) throws Xcept {
        this.isRunning = true;
        this.clear();
        this.overrides = overs;
        this.runCtxt = ctxt;
        this.runStat = new ASInfo.RunStatus();
        this.runDomain = null;
    }

    protected Data getLiveData(RTContext ctxt, Expr expr) throws Xcept {
        RTLiveQuery query = this.liveQueries.query(expr);
        if (query == null) {
            query = new RTLiveQuery(this.model, expr);
            this.liveQueries.add(query);
        }
        if (this.runStat.phase < query.phase()) {
            return null;
        }
        if (this.runStat.phase > query.phase()) {
            return query.getAllData(ctxt);
        }
        if (this.runDomain == null) {
            return null;
        }
        if (this.runCtxt == null) {
            return null;
        }
        int hix = this.runCtxt.inx(this.runDomain);
        query.update(ctxt, this.runDomain, hix);
        Data data = query.data();
        return data;
    }

    protected void startPhase(int i, RTRealDomain x) {
        this.runStat.phase = i;
        this.runStat.frac = 0.0;
        this.runDomain = x;
    }

    protected void updatePhase(double frac) {
        this.runStat.frac = frac;
    }

    protected void runCompleted() {
        this.isRunning = false;
    }

    protected void calcAssign(RTContext ctxt, RTVar v) throws Xcept {
        NamedVal nval;
        int vid = v.varID();
        if (!this.assignPending[vid]) {
            return;
        }
        if (!(v instanceof RTRealNVar)) {
            throw new Xcept((DiagInfo)v, "Cannot calculated assignment for variable");
        }
        ConstExpr expr = null;
        if (this.overrides != null && (nval = this.overrides.namedVal(v.name())) != null) {
            expr = Expr.cons((double)nval.realVal());
        }
        RealNData ndata = ((RTRealNVar)v).calcAssign(this, (Expr)expr, ctxt.random);
        this.setData(v, (Data)ndata);
        this.assignPending[vid] = false;
    }

    public String name() {
        return this.name;
    }

    public String sensP() {
        return this.sensP;
    }

    public double sensDelta() {
        return this.sensDelta;
    }

    public ASInfo.RunStatus runStat() {
        return this.runStat;
    }

    public Data data(RTVar v) {
        return this.data[v.varID()];
    }

    public RealNData ndata(RTVar v) {
        return (RealNData)this.data[v.varID()];
    }

    public GridData gdata(RTVar v) {
        return (GridData)this.data[v.varID()];
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public RTContext runCtxt() {
        return this.runCtxt;
    }

    public NamedVal namedVal(String n) throws Xcept {
        NamedVal nv;
        if (this.overrides != null && (nv = this.overrides.namedVal(n)) != null) {
            return nv;
        }
        return this.model.namedVal(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<RTDataStore> {
        public RTDataStore store(int i) throws Xcept {
            if (i < 0 || i >= this.size()) {
                throw new Xcept("invalid RTDataStore index");
            }
            return (RTDataStore)this.get(i);
        }
    }
}

