/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.jruntime.RTContext;
import JSim.jruntime.RTDataStore;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class RTDeriv
extends Expr {
    public RTModel model;
    public Expr u;
    public Expr v;

    public static Expr create(RTModel model, Expr u, Expr v) throws Xcept {
        if (u instanceof RTVar && v instanceof RTRealDomain) {
            return model.getVar("" + u + ":" + v);
        }
        return new RTDeriv(model, u, v);
    }

    public RTDeriv(RTModel m, Expr uu, Expr vv) throws Xcept {
        this.model = m;
        this.u = uu;
        this.v = vv;
        if (this.v instanceof RTVar && !((RTVar)this.v).isInput()) {
            throw new Xcept((DiagInfo)this, "Ad hoc run-time derivatives must be WRT input variable");
        }
    }

    public boolean sameAs(Expr e) {
        if (!(e instanceof RTDeriv)) {
            return false;
        }
        RTDeriv d = (RTDeriv)e;
        return this.u.sameAs(d.u) && this.v.sameAs(d.v);
    }

    public void addNamedExpr(Expr.List list) throws Xcept {
        this.u.addNamedExpr(list);
        this.v.addNamedExpr(list);
    }

    public void addDomains(Expr.List list) {
        this.u.addDomains(list);
        this.v.addDomains(list);
    }

    public int dataType() {
        return 4;
    }

    public double realVal(Context ctxt0) throws Xcept {
        double f1;
        RTContext ctxt = (RTContext)ctxt0;
        double f0 = this.u.realVal((Context)ctxt);
        RTDataStore pstore = this.model.sensStore(this.v.toString());
        if (pstore == null) {
            return Double.NaN;
        }
        ctxt = new RTContext(ctxt, pstore);
        try {
            f1 = this.u.realVal((Context)ctxt);
        }
        catch (Xcept e) {
            f1 = Double.NaN;
        }
        return (f1 - f0) / pstore.sensDelta();
    }

    public Expr unitCorrect() throws Xcept {
        Expr u1 = this.u.unitCorrect();
        Expr v1 = this.v.unitCorrect();
        return new RTDeriv(this.model, u1, v1);
    }

    public Unit unit() {
        Unit uunit = this.u.unit();
        Unit vunit = this.v.unit();
        if (uunit == null) {
            uunit = Unit.scalar();
        }
        if (vunit == null) {
            vunit = Unit.scalar();
        }
        try {
            return uunit.deriv(vunit);
        }
        catch (Xcept e) {
            return null;
        }
    }

    public Expr calculable(Known known) {
        return truex;
    }

    public Expr takeDomDeriv(NamedExpr t) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDeriv not implemented");
    }

    public Expr expandDeriv() throws Xcept {
        throw new Xcept((DiagInfo)this, "expandDeriv not implemented");
    }

    public Expr simplify(Known known) throws Xcept {
        throw new Xcept("RTDeriv.simplify() not implemented");
    }

    public String toString() {
        return "" + this.u + ":" + this.v;
    }

    public String toString(Context ctxt) {
        return this.toString();
    }
}

