/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.NamedVal;
import JSim.fgen.FgenContext;
import JSim.fgen.FgenMaster;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTSettingVar;
import JSim.jruntime.RTVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.ArrayList;

public class RTFuncGen
extends NamedExpr {
    private RTModel model;
    private String name;
    private FgenMaster[] fgens;
    private static NamedVal.NList defVals = FgenMaster.getDefaults();

    public RTFuncGen(RTModel model, String name) {
        this.model = model;
        this.name = name;
    }

    protected void allocThreads(int n) throws Xcept {
        this.fgens = new FgenMaster[n];
    }

    protected void runPrep(RTContext ctxt) throws Xcept {
        this.fgens[ctxt.threadInx] = null;
    }

    public double realVal(Context ctxt0) throws Xcept {
        if (!(ctxt0 instanceof FgenContext)) {
            throw new Xcept((DiagInfo)this, "realVal() requires FgenContext");
        }
        RTContext ctxt = (RTContext)ctxt0;
        int inx = ctxt.threadInx;
        if (this.fgens[inx] == null) {
            this.fgens[inx] = new FgenMaster(this.name());
        }
        return this.fgens[inx].realVal((FgenContext)ctxt);
    }

    public double finalRealVal() throws Xcept {
        return Double.NaN;
    }

    public NamedExpr getVar(String s) {
        if (this.name.equals(s)) {
            return this;
        }
        if (!s.startsWith(this.name + ".")) {
            return null;
        }
        String n = s.substring(this.name.length() + 1);
        NamedVal nval = defVals.namedVal(n);
        if (nval == null) {
            return null;
        }
        int dataType = nval.dataType();
        if (dataType == 0) {
            return null;
        }
        return new RTSettingVar(this.model, s, dataType);
    }

    public int dataType() {
        return 4;
    }

    public String toString() {
        return this.name;
    }

    public String toString(Context ctxt) {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public Unit unit() {
        return null;
    }

    public Expr unitCorrect() {
        return this;
    }

    public boolean isDomain() {
        return false;
    }

    public int ndim() {
        return 1;
    }

    public Expr takeDomDeriv(NamedExpr x) throws Xcept {
        throw new Xcept("RTFuncGen.takeDomDeriv not implemented");
    }

    public Expr expandDeriv() {
        return this;
    }

    public Expr calculable(Known known) {
        return truex;
    }

    public void addDomains(Expr.List list) {
        for (int i = 0; i < 2; ++i) {
            try {
                this.addDomain(i, list);
                continue;
            }
            catch (Xcept xcept) {
                // empty catch block
            }
        }
    }

    private void addDomain(int i, Expr.List list) throws Xcept {
        NamedVal xval = this.model.namedVal(this.name + ".domain" + i);
        if (xval == null) {
            return;
        }
        String xname = xval.stringVal();
        if (Util.isBlank((String)xname)) {
            return;
        }
        RTVar x = this.model.getVar(xname);
        if (x instanceof RTRealDomain) {
            list.addUniq((Expr)x);
        }
    }

    public boolean sameAs(Expr expr) {
        return this == expr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<RTFuncGen> {
        public RTFuncGen get(String n) {
            for (int i = 0; i < this.size(); ++i) {
                if (!((RTFuncGen)((Object)this.get(i))).name().equals(n)) continue;
                return (RTFuncGen)((Object)this.get(i));
            }
            return null;
        }

        public boolean update(RTModel model, String[] names) {
            int i;
            boolean changed = false;
            for (i = 0; i < names.length; ++i) {
                if (this.get(names[i]) != null) continue;
                this.add(new RTFuncGen(model, names[i]));
                changed = true;
            }
            for (i = 0; i < this.size(); ++i) {
                String name = ((RTFuncGen)((Object)this.get(i))).name();
                boolean found = false;
                for (int j = 0; j < names.length; ++j) {
                    if (!names[j].equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.remove(i);
                changed = true;
            }
            return changed;
        }
    }
}

