/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.aserver.ASInfo;
import JSim.aserver.ASModel;
import JSim.aserver.ASServer;
import JSim.data.Data;
import JSim.data.GridData;
import JSim.data.NamedVal;
import JSim.data.RealNData;
import JSim.jruntime.Fzero2Problem;
import JSim.jruntime.ODE1Problem;
import JSim.jruntime.PDE1Problem;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTDataStore;
import JSim.jruntime.RTDeriv;
import JSim.jruntime.RTFuncGen;
import JSim.jruntime.RTProblem;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.jruntime.RTSettingVar;
import JSim.jruntime.RTSolverSettings;
import JSim.jruntime.RTVar;
import JSim.jruntime.RTVarFuncCall;
import JSim.nml.opt.OptimFactory;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.NameSpace;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.Xcept;

public abstract class RTModel
implements DiagInfo,
NameSpace {
    public String name;
    public ASServer.Messenger messenger;
    public RTVar.NList vars;
    protected RTVar.NList domains;
    public RTProblem.List probs;
    public UnitNList units;
    protected boolean unitCorrect;
    protected ASModel.Flags flags;
    private RTDataStore[] stores;
    private RTFuncGen.List funcGens;
    private NamedVal.NList runVals;
    public boolean cancelRun;
    private OptimFactory optimFactory;
    protected int maxProc;
    protected int maxThreads;

    public RTModel(String n, UnitNList sysUnits, ASServer.Messenger msgr) throws Xcept {
        this.name = n;
        this.messenger = msgr;
        this.vars = new RTVar.NList(16);
        this.domains = new RTVar.NList(2);
        this.probs = new RTProblem.List(4);
        this.units = new UnitNList();
        if (sysUnits != null) {
            this.units.merge(sysUnits);
        }
        this.unitCorrect = this.defaultUnitCorrect();
        this.funcGens = new RTFuncGen.List();
        this.runVals = new NamedVal.NList();
    }

    protected void doneConstructor() throws Xcept {
        this.allocStores(0);
    }

    public void setOptimFactory(OptimFactory f) {
        this.optimFactory = f;
    }

    public OptimFactory optimFactory() {
        return this.optimFactory;
    }

    public abstract boolean defaultUnitCorrect();

    public void setDefault() throws Xcept {
        for (int i = 0; i < this.vars.size(); ++i) {
            this.vars.var(i).setDefault();
        }
    }

    public void add(RTVar v) throws Xcept {
        this.vars.add((Named)v);
    }

    public void add(RTProblem p) throws Xcept {
        this.probs.add(p);
    }

    public boolean allowMPRuns() {
        return false;
    }

    public void setMaxProc(int n) {
        this.maxProc = n;
        this.maxThreads = 2 * n;
    }

    public RTContext newRunContext(int threadInx, int nproc, RTDataStore s) throws Xcept {
        return new RTContext(this, threadInx, nproc, s, false);
    }

    public abstract void mainline(RTContext var1) throws Xcept;

    public void allocStores(int n) throws Xcept {
        int i;
        this.stores = new RTDataStore[n];
        for (i = 0; i < n; ++i) {
            this.stores[i] = new RTDataStore(this);
        }
        for (i = 0; i < this.probs.size(); ++i) {
            this.probs.prob(i).allocThreads(this.maxThreads);
        }
        for (i = 0; i < this.funcGens.size(); ++i) {
            ((RTFuncGen)((Object)this.funcGens.get(i))).allocThreads(this.maxThreads);
        }
    }

    public void allocStores(String[] names) throws Xcept {
        this.allocStores(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.stores[i].setName(names[i]);
        }
    }

    public void allocStores(String[] sensP, double[] sensDelta) throws Xcept {
        this.allocStores(sensP.length + 1);
        for (int i = 0; i < sensP.length; ++i) {
            this.stores[i + 1].setSens(sensP[i], sensDelta[i]);
        }
    }

    public void run(int threadInx, int nproc, int storeInx, NamedVal.NList overrides) throws Xcept {
        if (threadInx >= this.maxThreads) {
            throw new Xcept("Model run threadInx=" + threadInx + " exceeds maxThreads=" + this.maxThreads);
        }
        RTDataStore store = this.stores[storeInx];
        RTContext ctxt = this.newRunContext(threadInx, nproc, store);
        store.runPrep(ctxt, overrides);
        int seed = store.namedVal("solver.random_seed").intVal();
        ctxt.setRandomSeed(seed);
        Object x = null;
        try {
            this.runCaptive(ctxt);
            store.runCompleted();
        }
        catch (Exception e) {
            store.runCompleted();
            throw Xcept.wrap((Throwable)e);
        }
    }

    public void runCaptive(RTContext ctxt) throws Xcept {
        int i;
        int i2;
        ctxt.startPhase(1, null);
        RTVar.List stat = new RTVar.List(16);
        RTVar.List dyn = new RTVar.List(16);
        for (i2 = 0; i2 < this.vars.size(); ++i2) {
            RTVar v = this.vars.var(i2);
            if (!v.isInput()) continue;
            if (v.assign == null) {
                throw new Xcept((DiagInfo)v, "Variable has no valid assigned value");
            }
            if (v.ndim() > 0) {
                dyn.add((Object)v);
                continue;
            }
            stat.add((Object)v);
        }
        for (i2 = 0; i2 < this.probs.size(); ++i2) {
            this.probs.prob(i2).runPrep(ctxt);
        }
        for (i2 = 0; i2 < this.funcGens.size(); ++i2) {
            ((RTFuncGen)((Object)this.funcGens.get(i2))).runPrep(ctxt);
        }
        RTVar.List known = new RTVar.List(16);
        stat = this.sequence(stat, known);
        for (i = 0; i < this.vars.size(); ++i) {
            RTVar v = this.vars.var(i);
            if (!v.isDomain() && !stat.contains((Object)v)) continue;
            known.add((Object)v);
        }
        dyn = this.sequence(dyn, known);
        for (i = 0; i < stat.size(); ++i) {
            ctxt.calcAssign(stat.var(i));
        }
        ctxt.startPhase(2, null);
        this.mainline(ctxt);
        for (i = 0; i < dyn.size(); ++i) {
            ctxt.calcAssign(dyn.var(i));
        }
    }

    public void copyStore(int fromInx, int toInx) throws Xcept {
        this.stores[toInx] = this.stores[fromInx];
        this.stores[fromInx] = new RTDataStore(this);
    }

    public RTVar.List sequence(RTVar.List vlist, RTVar.List known) throws Xcept {
        Util.verbose((String)"==== Ordering input assignments");
        RTVar.List olist = new RTVar.List(vlist.size() + 1);
        boolean working = true;
        while (working) {
            working = false;
            for (int i = 0; i < vlist.size(); ++i) {
                RTVar v = vlist.var(i);
                if (olist.contains((Object)v)) continue;
                RTVar.List xlist = new RTVar.List(1);
                v.assign.addNamedExpr((Expr.List)xlist);
                boolean ok = true;
                for (int j = 0; j < xlist.size(); ++j) {
                    RTVar x;
                    if (!RTVar.class.isInstance(xlist.get(j)) || known.contains((Object)(x = xlist.var(j))) || olist.contains((Object)x)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                Util.verbose((String)("\t" + (Object)((Object)v) + " = " + v.assign));
                olist.add((Object)v);
                working = true;
            }
        }
        if (!olist.containSet((Expr.List)vlist)) {
            throw new Xcept("Input variable assignments have circular dependencies");
        }
        return olist;
    }

    protected final void interruptCheck() throws Xcept {
        if (this.cancelRun) {
            throw new Xcept("Model run cancelled");
        }
    }

    public String toString() {
        return "Model " + this.getClass().getName();
    }

    public final String diagInfo() {
        return this.toString();
    }

    public final ASInfo.RunStatus getRunStat(int inx) {
        if (inx >= this.nstores()) {
            return null;
        }
        if (this.stores[inx] == null) {
            return null;
        }
        ASInfo.RunStatus runStat = this.stores[inx].runStat();
        if (runStat == null) {
            return null;
        }
        return new ASInfo.RunStatus(runStat);
    }

    protected final RTDataStore finalStore() throws Xcept {
        if (this.nstores() < 1) {
            return null;
        }
        return this.stores[0];
    }

    public RTVar.List getVars() {
        RTVar.List list = new RTVar.List(1);
        for (int i = 0; i < this.vars.size(); ++i) {
            RTVar v = this.vars.var(i);
            if (v.isPrivate()) continue;
            list.add((Object)v);
        }
        return list;
    }

    public RTVar getVar(String n) throws Xcept {
        RTVar v = (RTVar)((Object)this.vars.getByName(n));
        if (v == null) {
            throw new Xcept("Variable " + n + " unknown");
        }
        if (v.isPrivate()) {
            throw new Xcept("Variable " + n + " is private.");
        }
        return v;
    }

    public NamedVal namedVal(String s) throws Xcept {
        NamedVal nval;
        if (this.runVals != null && (nval = this.runVals.namedVal(s)) != null) {
            return nval;
        }
        throw new Xcept("No RTModel.namedVal for " + s);
    }

    public Expr compByName(String s) throws Xcept {
        RTVar v = (RTVar)((Object)this.vars.getByName(s));
        if (v != null) {
            if (v.isPrivate()) {
                throw new Xcept("Variable " + s + " is private.");
            }
            return v;
        }
        RTSettingVar sv = null;
        sv = RTSolverSettings.getSettingVar(this, s);
        if (sv != null) {
            return sv;
        }
        for (int i = 0; i < this.funcGens.size(); ++i) {
            sv = ((RTFuncGen)((Object)this.funcGens.get(i))).getVar(s);
            if (sv == null) continue;
            return sv;
        }
        throw new Xcept("Unknown variable: " + s);
    }

    public Unit unitByName(String s) throws Xcept {
        return this.units.byName(s);
    }

    public RTFuncGen.List funcGens() {
        return this.funcGens;
    }

    public Expr funcCall(String n, Expr.List elist) throws Xcept {
        RTVar v;
        try {
            v = this.getVar(n);
        }
        catch (Xcept e) {
            return IExpr.create((String)n, (Expr.List)elist);
        }
        if (v.isDomain() || elist.size() != v.ndim()) {
            throw new Xcept((DiagInfo)v, "variable function requires " + v.ndim() + " arguments");
        }
        RTVar.List domlist = v.domainList();
        if (domlist.sameAs(elist)) {
            return v;
        }
        return new RTVarFuncCall((RTRealNVar)v, elist);
    }

    public Expr parseExpr(String s) throws Xcept {
        Expr expr = Expr.parse((NameSpace)this, (String)s);
        if (this.unitCorrect) {
            expr.unitCorrect();
        }
        return expr;
    }

    public Unit unit(Expr expr) throws Xcept {
        Unit u;
        if (this.unitCorrect && IExpr.class.isInstance(expr)) {
            expr = expr.unitCorrect();
        }
        return (u = expr.unit()) == null ? Unit.scalar() : u;
    }

    public Unit parseUnit(String s) throws Xcept {
        return Unit.parse((NameSpace)this, (String)("1 " + s));
    }

    public Expr makeDeriv(Expr e1, Expr e2) throws Xcept {
        return RTDeriv.create(this, e1, e2);
    }

    public Data getData(int n, Expr expr) throws Xcept {
        if (n >= this.nstores()) {
            return null;
        }
        RTDataStore store = this.stores[n];
        RTContext ctxt = store.runCtxt();
        if (ctxt == null) {
            return null;
        }
        int tx = ctxt.threadInx;
        RTContext qctxt = new RTContext(this, tx, 1, this.stores[n], true);
        return this.getData(qctxt, expr, null, null);
    }

    protected Data getData(RTContext ctxt, Expr expr, RTRealDomain[] addDoms, Unit forceUnit) throws Xcept {
        try {
            if (ctxt.isQuery() && ctxt.store.isRunning()) {
                return ctxt.store.getLiveData(ctxt, expr);
            }
            Data d = this.getAllData(ctxt, expr, addDoms, forceUnit);
            if (d != null) {
                d.subset = null;
            }
            return d;
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    protected Data getAllData(RTContext ctxt, Expr expr, RTRealDomain[] addDoms, Unit forceUnit) throws Xcept {
        boolean nomake;
        boolean bl = nomake = forceUnit == null && expr instanceof RTVar;
        if (nomake) {
            return ctxt.store().data((RTVar)expr);
        }
        return this.makeData(ctxt, expr, addDoms, forceUnit);
    }

    private RealNData makeData(RTContext ctxt, Expr expr, RTRealDomain[] addDoms, Unit forceUnit) throws Xcept {
        RTVar.List doms = new RTVar.List(4);
        if (addDoms != null) {
            for (int i = 0; i < addDoms.length; ++i) {
                doms.addUniq((Expr)addDoms[i]);
            }
        }
        expr.addDomains((Expr.List)doms);
        GridData[] grids = new GridData[doms.size()];
        for (int i = 0; i < doms.size(); ++i) {
            RTRealDomain x = (RTRealDomain)((Object)doms.get(i));
            grids[i] = ctxt.grid(x);
        }
        String desc = expr.toString();
        if (this.unitCorrect) {
            expr = expr.unitCorrect();
        }
        Unit exprUnit = expr.unit();
        Unit dataUnit = forceUnit == null ? exprUnit : forceUnit;
        RealNData ndata = new RealNData(desc, dataUnit, grids);
        ndata.setGroup(ctxt.store().name());
        double ufactor = 1.0;
        if (this.unitCorrect) {
            if (!Unit.compatible((Unit)expr.unit(), (Unit)dataUnit)) {
                throw new Xcept((DiagInfo)expr, "assignment incompatible with unit " + dataUnit.pubName());
            }
            ufactor = Unit.convertFactor((Unit)dataUnit, (Unit)expr.unit());
        }
        int nsamp = ndata.nsamples();
        for (int i = 0; i < nsamp; ++i) {
            int[] gpos = ndata.gridPos(i);
            for (int j = 0; j < doms.size(); ++j) {
                RTRealDomain x = (RTRealDomain)((Object)doms.get(j));
                ctxt.setInx(x, gpos[j]);
            }
            ndata.set(i, expr.realVal((Context)ctxt) * ufactor);
        }
        return ndata;
    }

    public String getStoreName(int i) {
        if (i < 0 || i >= this.nstores()) {
            return null;
        }
        return this.stores[i].name();
    }

    public void badRelation(String s) throws Xcept {
        throw new Xcept((DiagInfo)this, "Required relation failed: " + s);
    }

    public void badICBC(String s, NamedExpr v, double resid) throws Xcept {
        throw new Xcept((DiagInfo)this, s + ": residual=" + resid);
    }

    protected RTDataStore sensStore(String p) throws Xcept {
        for (int i = 1; i < this.stores.length; ++i) {
            String sp = this.stores[i].sensP();
            if (sp == null || !p.equals(sp)) continue;
            return this.stores[i];
        }
        return null;
    }

    public int nstores() {
        if (this.stores == null) {
            return 0;
        }
        return this.stores.length;
    }

    public void warning(String msg) {
        if (this.messenger != null) {
            this.messenger.message(new ASInfo.Message(null, true, msg));
        }
    }

    public void setFuncGenNames(String[] names) throws Xcept {
        boolean changed = this.funcGens.update(this, names);
        if (changed) {
            // empty if block
        }
    }

    public void setRunVals(NamedVal.NList nvals) {
        this.runVals = nvals == null ? new NamedVal.NList() : nvals;
    }

    public ASModel.Flags getFlags() {
        int i;
        if (this.flags != null) {
            return this.flags;
        }
        this.flags = new ASModel.Flags();
        this.flags.needsUnitCorrect = this.defaultUnitCorrect();
        for (i = 0; i < this.vars.size(); ++i) {
            Unit u = this.vars.var(i).unit();
            if (Unit.same((Unit)u, (Unit)Unit.scalar())) continue;
            this.flags.needsUnits = true;
            break;
        }
        for (i = 0; i < this.probs.size(); ++i) {
            RTProblem prob = this.probs.prob(i);
            if (prob instanceof ODE1Problem) {
                this.flags.usesODESolver = true;
            }
            if (prob instanceof PDE1Problem) {
                PDE1Problem pprob = (PDE1Problem)prob;
                for (int j = 0; j < ASModel.PDE_Solvers.length; ++j) {
                    this.flags.usesPDESolvers[j] = pprob.usesPDESolver(j);
                }
            }
            if (!(prob instanceof Fzero2Problem)) continue;
            this.flags.usesFzero2Solver = true;
        }
        this.flags.usesRandom = true;
        return this.flags;
    }
}

