/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.aserver.ASVar;
import JSim.data.Data;
import JSim.data.RegularGridData;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTIntNVar;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealNVar;
import JSim.jruntime.RTVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.Xcept;

public final class RTRealDomain
extends RTVar {
    public RTRealNVar vmin;
    public RTRealNVar vmax;
    public RTRealNVar vdelta;
    public RTIntNVar vct;
    private int domainID;

    public RTRealDomain(RTModel m, String n, String u, int ph, RTRealNVar v1, RTRealNVar v2, RTRealNVar v3, RTIntNVar v4) throws Xcept {
        super(m, n, u, ph);
        this.vmin = v1;
        this.vmax = v2;
        this.vdelta = v3;
        this.vct = v4;
        this.domainID = this.model.domains.size();
        this.model.domains.add((Named)this);
    }

    public void setGridRegular(RTContext ctxt) throws Xcept {
        int ct = ctxt.intVal(this.vct);
        double min = ctxt.realVal(this.vmin);
        double max = ctxt.realVal(this.vmax);
        double delta = ctxt.realVal(this.vdelta);
        if (ct < 2) {
            throw new Xcept((DiagInfo)this, "Attempt to set domain grid ct < 2");
        }
        ctxt.unSet(this);
        RegularGridData grid = new RegularGridData(this.name, this.unit, min, max, ct);
        ctxt.store().setData(this, (Data)grid);
    }

    public int ndim() {
        return 1;
    }

    public boolean isDomain() {
        return true;
    }

    public ASVar domain(int i) {
        return this;
    }

    public int domainID() {
        return this.domainID;
    }

    public double realVal(Context ctxt0) throws Xcept {
        if (!(ctxt0 instanceof RTContext)) {
            throw new Xcept((DiagInfo)this, "realVal(ctxt) requires RTContext");
        }
        RTContext ctxt = (RTContext)ctxt0;
        return ctxt.realVal(this);
    }

    public void addDomains(Expr.List list) {
        list.addUniq((Expr)this);
    }
}

