/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.Data;
import JSim.data.GridData;
import JSim.data.RealNData;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTDataStore;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTNVar;
import JSim.jruntime.RTRealDomain;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.Random;

public class RTRealNVar
extends RTNVar {
    public RTRealNVar(RTModel m, String n, String u, int ph, RTRealDomain[] d) throws Xcept {
        super(m, n, u, ph, d);
    }

    public double realVal(Context ctxt0) throws Xcept {
        if (!(ctxt0 instanceof RTContext)) {
            throw new Xcept((DiagInfo)this, "realVal(ctxt) requires RTContext");
        }
        RTContext ctxt = (RTContext)ctxt0;
        return ctxt.realVal(this);
    }

    protected RealNData makeData(RTContext ctxt) throws Xcept {
        Util.verbose((String)("\t" + (Object)((Object)this) + " makeData"));
        GridData[] grids = new GridData[this.ndim()];
        for (int i = 0; i < this.ndim(); ++i) {
            grids[i] = ctxt.grid(this.doms[i]);
        }
        return new RealNData(this.name(), this.unit(), grids);
    }

    protected RealNData calcAssign(RTDataStore store, Expr expr, Random random) throws Xcept {
        Data data;
        RTContext ctxt = new RTContext(this.model, store.runCtxt().threadInx, 1, store, false);
        ctxt.random = random;
        if (expr == null) {
            expr = this.assign;
        }
        if ((data = this.model.getData(ctxt, expr, this.doms, this.unit())).ndim() != this.ndim()) {
            throw new Xcept((DiagInfo)this, "calcAssign() returned data dimension " + data.ndim() + " s/b " + this.ndim());
        }
        RealNData ndata = null;
        if (data instanceof RealNData) {
            ndata = (RealNData)data;
        } else if (data instanceof GridData) {
            ndata = new RealNData((GridData)data);
        } else {
            throw new Xcept((DiagInfo)this, "Assign returned unsupported data type");
        }
        ndata.setDesc(this.name());
        return ndata;
    }
}

