/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.NamedVal;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.util.Context;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class RTSettingVar
extends NamedExpr {
    private RTModel model;
    private String name;
    private int dataType;

    public RTSettingVar(RTModel model, String name, int dataType) {
        this.model = model;
        this.name = name;
        this.dataType = dataType;
    }

    public double realVal(Context ctxt) throws Xcept {
        return this.namedVal(ctxt).realVal();
    }

    public boolean boolVal(Context ctxt) throws Xcept {
        return this.namedVal(ctxt).boolVal();
    }

    public String stringVal(Context ctxt) throws Xcept {
        return this.namedVal(ctxt).stringVal();
    }

    private NamedVal namedVal(Context ctxt) throws Xcept {
        if (!(ctxt instanceof RTContext)) {
            throw new Xcept("RTSettingVar.namedVal requires RTContext");
        }
        NamedVal nval = ((RTContext)ctxt).namedVal(this.name);
        if (nval == null) {
            throw new Xcept("RTSettingVar " + this.name + ": setting not found");
        }
        return nval;
    }

    public String name() {
        return this.name;
    }

    public String diagInfo() {
        return "Setting " + this.name;
    }

    public String toString() {
        return this.name;
    }

    public String toString(Context ctxt) {
        return ctxt.newName((Named)this);
    }

    public Expr takeDomDeriv(NamedExpr e) {
        return zero;
    }

    public Expr expandDeriv() {
        return this;
    }

    public Expr unitCorrect() {
        return this;
    }

    public Unit unit() {
        return null;
    }

    public Expr calculable(Known k) {
        return truex;
    }

    public void addDomains(Expr.List list) {
    }

    public boolean sameAs(Expr e) {
        if (!(e instanceof RTSettingVar)) {
            return false;
        }
        return this.name.equals(((RTSettingVar)e).name());
    }

    public int dataType() {
        return this.dataType;
    }
}

