/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.GridData;
import JSim.data.RealNData;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.jruntime.RTVar;
import JSim.jruntime.RTXFuncCall;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Xcept;
import java.util.ArrayList;

public class RTXFuncArg
implements DiagInfo {
    private RTXFuncCall funcCall;
    private int argn;
    private RTRealDomain[] argDoms;
    private RTVar v;
    private boolean isInput;

    public RTXFuncArg(RTXFuncCall fc, RTRealDomain[] ad, RTVar vv, boolean isIn) {
        this.funcCall = fc;
        this.argDoms = ad;
        this.v = vv;
        this.isInput = isIn;
        RTVar.List list = this.v.domainList();
        this.argn = this.funcCall.args.size();
        this.funcCall.addArg(this);
    }

    public RTXFuncArg(RTXFuncCall fc, RTRealDomain[] ad) {
        this.funcCall = fc;
        this.argDoms = ad;
        this.v = null;
        this.isInput = true;
        this.argn = this.funcCall.args.size();
        this.funcCall.addArg(this);
    }

    protected double getRealVal(RTContext ctxt) throws Xcept {
        throw new Xcept("RTXFuncArg.getRealVal() not implemented");
    }

    public int ndim() {
        return this.argDoms.length;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public String diagInfo() {
        return this.funcCall.name() + " arg" + this.argn;
    }

    protected final RealNData loadData(RTContext ctxt) throws Xcept {
        int i;
        int[] saveState = new int[this.ndim()];
        GridData[] grids = new GridData[this.ndim()];
        for (int i2 = 0; i2 < this.ndim(); ++i2) {
            saveState[i2] = ctxt.getState(this.argDoms[i2]);
            grids[i2] = ctxt.grid(this.argDoms[i2]);
        }
        RealNData ndata = new RealNData("arg" + this.argn, null, grids);
        if (!this.isInput()) {
            return ndata;
        }
        for (i = 0; i < ndata.nsamples(); ++i) {
            int[] gpos = ndata.gridPos(i);
            for (int j = 0; j < this.ndim(); ++j) {
                ctxt.setInx(this.argDoms[j], gpos[j]);
            }
            double val = this.v == null ? this.getRealVal(ctxt) : this.v.realVal((Context)ctxt);
            ndata.set(i, val);
        }
        for (i = 0; i < this.ndim(); ++i) {
            ctxt.setState(this.argDoms[i], saveState[i]);
        }
        return ndata;
    }

    protected void unloadData(RTContext ctxt, RealNData ndata) throws Xcept {
        int i;
        if (this.isInput()) {
            return;
        }
        if (!(this.v instanceof RTRealNVar)) {
            throw new Xcept((DiagInfo)this, (DiagInfo)this.v, "only RTRealNVar's supported in unloadData()");
        }
        RTRealNVar nv = (RTRealNVar)this.v;
        int[] saveState = new int[this.ndim()];
        for (i = 0; i < this.ndim(); ++i) {
            saveState[i] = ctxt.getState(this.argDoms[i]);
        }
        for (i = 0; i < ndata.nsamples(); ++i) {
            int[] gpos = ndata.gridPos(i);
            for (int j = 0; j < this.ndim(); ++j) {
                ctxt.setInx(this.argDoms[j], gpos[j]);
            }
            ctxt.set(nv, ndata.realVal(i));
        }
        for (i = 0; i < this.ndim(); ++i) {
            ctxt.setState(this.argDoms[i], saveState[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<RTXFuncArg> {
        public List(int i) {
            super(i);
        }

        public RTXFuncArg arg(int i) {
            return (RTXFuncArg)this.get(i);
        }
    }
}

