/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.jruntime.RTModel;
import JSim.util.Xcept;

public abstract class RTXSimModel {
    protected RTModel rtmodel;

    public void setModel(RTModel m) {
        this.rtmodel = m;
    }

    public int pSize() {
        return this.xsimPSize();
    }

    public void setP(int loc, double v) {
        this.xsimSetP(loc, v);
    }

    public double getP(int loc) {
        return this.xsimGetP(loc);
    }

    public void init() throws Xcept {
        this.xsimini();
    }

    public void loop() throws Xcept {
        this.xsimlop();
    }

    public void comp() throws Xcept {
        this.xsimend();
    }

    public double[] getP(int loc, int n, int incr) {
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.xsimGetP(loc);
            loc += incr;
        }
        return d;
    }

    public void setP(int loc, int n, int incr, double[] d) {
        for (int i = 0; i < n; ++i) {
            this.xsimSetP(loc, d[i]);
            loc += incr;
        }
    }

    public void warning(String s) {
        if (this.rtmodel != null && s != null) {
            this.rtmodel.warning(s);
        }
    }

    public void fatal(String s) throws Xcept {
        throw new Xcept(s);
    }

    protected abstract int xsimPSize();

    protected abstract void xsimSetP(int var1, double var2);

    protected abstract double xsimGetP(int var1);

    protected abstract void xsimini() throws Xcept;

    protected abstract void xsimlop() throws Xcept;

    protected abstract void xsimend() throws Xcept;
}

