/*
 * Decompiled with CFR 0.152.
 */
package JSim.mathml;

import JSim.mml.Eqn;
import JSim.mml.Integral;
import JSim.mml.IntegralAt;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.SubDom;
import JSim.mml.Summation;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.util.BoolConst;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.NamedExpr;
import JSim.util.RealConst;
import JSim.util.StringList;
import JSim.util.Util;
import JSim.util.XFuncArg;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MLWriter {
    private Document doc;
    private Element base;
    private boolean addParagraphs;
    private static String[] names;

    public MLWriter(Element e) {
        this.base = e;
        this.doc = this.base.getOwnerDocument();
        MLWriter.initNames();
        this.addParagraphs = false;
    }

    public void setParagraphs(boolean b) {
        this.addParagraphs = b;
    }

    public void add(Model model) throws Xcept {
        int i;
        MathSys math = model.getFlatMath();
        for (i = 0; i < math.voidFuncCalls.size(); ++i) {
            this.add(math.voidFuncCalls.expr(i));
        }
        for (i = 0; i < math.eqn.size(); ++i) {
            this.add(math.eqn.eqn(i));
        }
    }

    public void add(Eqn eqn) throws Xcept {
        SubDom sdom = eqn.sdom();
        Expr expr = eqn.expr();
        if (sdom.isEntire()) {
            this.add(expr);
            return;
        }
        Expr.List doms = new Expr.List(2);
        expr.addDomains(doms);
        Expr xexpr = sdom.expr;
        Element apply = this.doc.createElement("apply");
        Element forall = this.doc.createElement("forall");
        apply.appendChild(forall);
        for (int i = 0; i < doms.size(); ++i) {
            this.addBVar(apply, doms.expr(i).toString(), 1);
        }
        Element cond = this.doc.createElement("condition");
        this.add(cond, xexpr);
        apply.appendChild(cond);
        this.add(apply, expr);
        this.newWrapper().appendChild(apply);
    }

    public void add(Expr expr) throws Xcept {
        this.add(this.newWrapper(), expr);
    }

    private Element newWrapper() {
        Element math = this.doc.createElement("math");
        math.setAttribute("xmlns", "http://www.w3.org/1998/Math/MathML");
        if (this.addParagraphs) {
            Element p = this.doc.createElement("p");
            this.base.appendChild(p);
            p.appendChild(math);
        } else {
            this.base.appendChild(math);
        }
        return math;
    }

    private void add(Element elem, Expr expr) throws Xcept {
        if (expr instanceof NamedExpr) {
            this.addNamed(elem, (NamedExpr)expr);
        } else if (expr instanceof RealConst) {
            this.addConst(elem, expr.realVal(null));
        } else if (expr instanceof BoolConst) {
            this.addConst(elem, expr.boolVal(null));
        } else if (expr instanceof IExpr) {
            this.addIExpr(elem, (IExpr)expr);
        } else if (expr instanceof VarFuncCall) {
            this.addVarFunc(elem, (VarFuncCall)expr);
        } else if (expr instanceof XFuncCall) {
            this.addXFunc(elem, (XFuncCall)expr);
        } else if (expr instanceof Integral) {
            Integral in = (Integral)expr;
            this.addIntegralSum(elem, "int", (Expr)in.t(), in.min(), in.max(), in.u());
        } else if (expr instanceof Summation) {
            Summation s = (Summation)expr;
            this.addIntegralSum(elem, "sum", (Expr)s.t(), s.min(), s.max(), s.u());
        } else if (expr instanceof IntegralAt) {
            IntegralAt in = (IntegralAt)expr;
            this.addIntegralSum(elem, "int", (Expr)in.t(), in.min(), in.max(), in.u());
        } else {
            this.addBogus(elem, expr);
        }
    }

    private void addNamed(Element elem, NamedExpr expr) throws Xcept {
        StringTokenizer stok = new StringTokenizer(expr.toString(), ":");
        int nbvars = stok.countTokens() - 1;
        if (nbvars < 1) {
            this.addNamedVar(elem, expr.toString());
            return;
        }
        String name = stok.nextToken();
        StringList bnames = new StringList();
        int degreeTot = 0;
        int[] degrees = new int[nbvars];
        for (int i = 0; i < nbvars; ++i) {
            int j;
            String bname = stok.nextToken();
            bnames.addUniq(bname);
            int n = j = bnames.indexOf(bname);
            degrees[n] = degrees[n] + 1;
            ++degreeTot;
        }
        Element apply = this.doc.createElement("apply");
        int ndim = expr instanceof Var ? ((Var)expr).ndim() : 1;
        String dname = ndim > 1 ? "partialdiff" : "diff";
        Element diff = this.doc.createElement(dname);
        apply.appendChild(diff);
        for (int i = 0; i < bnames.size(); ++i) {
            if (degrees[i] == 0) continue;
            this.addBVar(apply, bnames.str(i), degrees[i]);
        }
        this.addNamedVar(apply, name);
        elem.appendChild(apply);
    }

    private void addBVar(Element elem, String name, int degree) throws Xcept {
        Element bvar = this.doc.createElement("bvar");
        this.addNamedVar(bvar, name);
        if (degree > 1) {
            this.addDegree(bvar, degree);
        }
        elem.appendChild(bvar);
    }

    private void addDegree(Element elem, int degree) throws Xcept {
        Element deg = this.doc.createElement("degree");
        this.addConst(deg, degree);
        elem.appendChild(deg);
    }

    private void addNamedVar(Element elem, String name) throws Xcept {
        Element e = this.doc.createElement("ci");
        Text text = this.doc.createTextNode(name);
        e.appendChild(text);
        elem.appendChild(e);
    }

    private void addConst(Element elem, double value) throws Xcept {
        if (value == Expr.pi.realVal(null)) {
            Element pi = this.doc.createElement("pi");
            elem.appendChild(pi);
        } else {
            Element e = this.doc.createElement("cn");
            Text text = this.doc.createTextNode(Util.pretty((double)value));
            e.appendChild(text);
            elem.appendChild(e);
        }
    }

    private void addConst(Element elem, boolean value) throws Xcept {
        String n = value ? "true" : "false";
        Element e = this.doc.createElement(n);
        elem.appendChild(e);
    }

    private void addIExpr(Element elem, IExpr expr) throws Xcept {
        int op = expr.op();
        if (op == 59) {
            this.addIf(elem, expr);
            return;
        }
        Element apply = this.doc.createElement("apply");
        String name = names[op];
        Expr[] args = new Expr[expr.nargs()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = expr.arg(i);
        }
        switch (op) {
            case 36: {
                args = new Expr[]{args[1].div(args[0])};
                break;
            }
            case 21: {
                name = "floor";
                args[0] = args[0].add((Expr)Expr.cons((double)0.5));
            }
        }
        if (name == null) {
            name = "op_" + op;
        }
        Element e = this.doc.createElement(name);
        apply.appendChild(e);
        this.add(apply, args);
        elem.appendChild(apply);
    }

    private void addIf(Element elem, IExpr expr) throws Xcept {
        Expr a = expr.arg(0);
        Expr b = expr.arg(1);
        Expr c = expr.arg(2);
        Element pwise = this.doc.createElement("piecewise");
        Element piece = this.doc.createElement("piece");
        this.add(piece, b);
        this.add(piece, a);
        pwise.appendChild(piece);
        Element other = this.doc.createElement("otherwise");
        this.add(other, c);
        pwise.appendChild(other);
        elem.appendChild(pwise);
    }

    private void addVarFunc(Element elem, VarFuncCall fcall) throws Xcept {
        this.addFunc(elem, fcall.v.toString(), fcall.args);
    }

    private void addXFunc(Element elem, XFuncCall fcall) throws Xcept {
        String name = fcall.func().name();
        XFuncArg.List xargs = fcall.args();
        Expr.List args = new Expr.List(xargs.size());
        for (int i = 0; i < xargs.size(); ++i) {
            args.add((Object)xargs.arg(i).base());
        }
        this.addFunc(elem, name, args);
    }

    private void addFunc(Element elem, String f, Expr.List args) throws Xcept {
        Element apply = this.doc.createElement("apply");
        Element felem = this.doc.createElement("ci");
        felem.setAttribute("type", "function");
        Text ftext = this.doc.createTextNode(f);
        felem.appendChild(ftext);
        apply.appendChild(felem);
        for (int i = 0; i < args.size(); ++i) {
            this.add(apply, args.expr(i));
        }
        elem.appendChild(apply);
    }

    private void addIntegralSum(Element elem, String type, Expr x, Expr xlo, Expr xhi, Expr expr) throws Xcept {
        Element apply = this.doc.createElement("apply");
        Element integral = this.doc.createElement(type);
        apply.appendChild(integral);
        this.addBVar(apply, x.toString(), 1);
        Element lolim = this.doc.createElement("lowlimit");
        this.add(lolim, xlo);
        apply.appendChild(lolim);
        Element hilim = this.doc.createElement("uplimit");
        this.add(hilim, xhi);
        apply.appendChild(hilim);
        this.add(apply, expr);
        elem.appendChild(apply);
    }

    private void addBogus(Element elem, Expr expr) throws Xcept {
        Element e = this.doc.createElement("bogus");
        e.setAttribute("str", expr.toString());
        e.setAttribute("class", expr.getClass().getName());
        elem.appendChild(e);
    }

    private void add(Element elem, Expr[] exprs) throws Xcept {
        for (int i = 0; i < exprs.length; ++i) {
            this.add(elem, exprs[i]);
        }
    }

    private static void initNames() {
        if (names != null) {
            return;
        }
        names = new String[62];
        MLWriter.names[41] = "eq";
        MLWriter.names[42] = "neq";
        MLWriter.names[45] = "gt";
        MLWriter.names[43] = "lt";
        MLWriter.names[46] = "geq";
        MLWriter.names[44] = "leq";
        MLWriter.names[47] = "approx";
        MLWriter.names[31] = "plus";
        MLWriter.names[32] = "minus";
        MLWriter.names[33] = "times";
        MLWriter.names[34] = "divide";
        MLWriter.names[35] = "power";
        MLWriter.names[37] = "rem";
        MLWriter.names[18] = "abs";
        MLWriter.names[8] = "exp";
        MLWriter.names[3] = "ln";
        MLWriter.names[4] = "log";
        MLWriter.names[20] = "floor";
        MLWriter.names[19] = "ceiling";
        MLWriter.names[51] = "and";
        MLWriter.names[52] = "or";
        MLWriter.names[27] = "not";
        MLWriter.names[5] = "sin";
        MLWriter.names[6] = "cos";
        MLWriter.names[7] = "tan";
        MLWriter.names[10] = "arcsin";
        MLWriter.names[11] = "arccos";
        MLWriter.names[36] = "arctan";
        MLWriter.names[12] = "sinh";
        MLWriter.names[13] = "cosh";
        MLWriter.names[14] = "tanh";
        MLWriter.names[15] = "arcsinh";
        MLWriter.names[16] = "arccosh";
        MLWriter.names[17] = "arctanh";
        MLWriter.names[9] = "root";
    }
}

