/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.util.CompareExpr;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.JSLang;
import JSim.util.Unit;
import JSim.util.UnitXcept;
import JSim.util.Util;
import JSim.util.Xcept;
import JSim.util.XceptPos;
import java.util.ArrayList;

public class Eqn
implements DiagInfo {
    protected Comp parent;
    protected SubDom sdom;
    public Expr lhs;
    public int op;
    public Expr rhs;
    public XceptPos pos;
    protected boolean builtin;
    protected Var.List varList;
    protected Var.List lhsVarList;
    protected Var.List rhsVarList;
    protected int flatInx;
    private Expr diagLHS;
    private Expr diagRHS;

    public Eqn(Comp p, Expr sd, Expr lh, int o, Expr rh) throws Xcept {
        this.parent = p;
        this.sdom = new SubDom(sd);
        this.lhs = lh;
        this.op = o;
        this.rhs = rh;
        this.builtin = true;
        this.diagLHS = this.lhs;
        this.diagRHS = this.rhs;
        this.parent.registerEqn(this);
    }

    public static Eqn create(Comp p, Expr sd, Expr e, XceptPos ps) throws Xcept {
        if (!(e instanceof CompareExpr)) {
            throw new Xcept((DiagInfo)e, "Equation or relation expected");
        }
        CompareExpr rexpr = (CompareExpr)e;
        Eqn eqn = new Eqn(p, sd, rexpr.arg(0), rexpr.op(), rexpr.arg(1));
        eqn.pos = ps;
        return eqn;
    }

    protected void expandDeriv() throws Xcept {
        Util.verbose((String)(this.parent.name() + ".expandDeriv() " + this.toString()));
        Expr sd = this.sdom.expr.expandDeriv();
        this.sdom = new SubDom(sd);
        this.lhs = this.lhs.expandDeriv();
        this.rhs = this.rhs.expandDeriv();
        Util.verbose((String)("  result: " + this.toString()));
        this.rhsVarList = null;
        this.lhsVarList = null;
        this.varList = null;
    }

    public void unitCorrect() throws Xcept {
        try {
            this.sdom = this.sdom.unitCorrect();
            this.lhs = this.lhs.unitCorrect();
            this.rhs = this.rhs.unitCorrect();
            Unit lu = this.lhs.unit();
            Unit ru = this.rhs.unit();
            if (!Unit.compatible((Unit)lu, (Unit)ru)) {
                throw new UnitXcept((IExpr)this.lhs.eq(this.rhs), this.lhs, this.rhs, lu, ru);
            }
            this.rhs = this.rhs.multUnit(lu, ru);
        }
        catch (UnitXcept e) {
            e.units = this.parent.getModel().units;
            e.pos = this.pos;
            throw e;
        }
    }

    public void simplify() throws Xcept {
        this.sdom = new SubDom(this.sdom.expr.simplify());
        this.lhs = this.lhs.simplify();
        this.rhs = this.rhs.simplify();
        this.rhsVarList = null;
        this.lhsVarList = null;
        this.varList = null;
    }

    public String toString() {
        String s;
        String string = s = this.builtin ? "builtin " : "";
        if (!this.sdom.isEntire()) {
            s = "when (" + this.sdom.toString() + ") ";
        }
        s = s + this.lhs.toString() + " " + JSLang.lang.chars(this.op) + " " + this.rhs.toString() + ";";
        return s;
    }

    public String diagInfo() {
        String s = "Equation ";
        if (!this.sdom.isEntire()) {
            s = "when (" + this.sdom.toString() + ") ";
        }
        s = s + this.diagLHS.toString() + " " + JSLang.lang.chars(this.op) + " " + this.diagRHS.toString() + ";";
        if (this.pos != null) {
            s = s + " " + this.pos;
        }
        return s;
    }

    public int flatInx() {
        return this.flatInx;
    }

    public SubDom sdom() {
        return this.sdom;
    }

    public Expr subdom() {
        return this.sdom.expr;
    }

    public boolean isEqn() {
        return this.op == 41;
    }

    public Expr expr() throws Xcept {
        return new CompareExpr(this.op, this.lhs, this.rhs);
    }

    public String toString(Context ctxt) {
        String s = "";
        if (!this.sdom.isEntire()) {
            s = "when (" + this.sdom.toString(ctxt) + ") ";
        }
        s = s + this.lhs.toString(ctxt) + " " + ctxt.lang.chars(this.op) + " " + this.rhs.toString(ctxt) + ";";
        return s;
    }

    public Var.List varList() throws Xcept {
        if (this.varList == null) {
            this.varList = (Var.List)((Object)this.lhsVarList().clone());
            this.varList.addUniq(this.rhsVarList());
        }
        return this.varList;
    }

    public Var.List lhsVarList() throws Xcept {
        if (this.lhsVarList == null) {
            this.lhsVarList = new Var.List(this.lhs);
        }
        return this.lhsVarList;
    }

    public Var.List rhsVarList() throws Xcept {
        if (this.rhsVarList == null) {
            this.rhsVarList = new Var.List(this.rhs);
        }
        return this.rhsVarList;
    }

    public boolean canSolve(Var v) throws Xcept {
        return this.varList.contains((Object)v);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<Eqn> {
        public List(int n) {
            super(n);
        }

        public Eqn eqn(int i) {
            return (Eqn)this.get(i);
        }

        @Override
        public String toString() {
            return this.toString(null);
        }

        public String toString(Context ctxt) {
            String s = "";
            for (int i = 0; i < this.size(); ++i) {
                s = s + "\t" + (ctxt == null ? this.eqn(i).toString() : this.eqn(i).toString(ctxt)) + "\n";
            }
            return s;
        }
    }
}

