/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Eqn;
import JSim.mml.MathSys;
import JSim.util.DiagInfo;

public class EqnSet
implements DiagInfo {
    public MathSys math;
    public boolean[] hasEqn;
    public int size;

    public EqnSet(MathSys m) {
        this.math = m;
        this.hasEqn = new boolean[this.math.eqn.size()];
        this.size = 0;
    }

    public EqnSet(EqnSet e) {
        this.math = e.math;
        this.hasEqn = (boolean[])e.hasEqn.clone();
        this.size = e.size;
    }

    public void add(Eqn e) {
        int i = e.flatInx();
        if (!this.hasEqn[i]) {
            ++this.size;
        }
        this.hasEqn[i] = true;
    }

    public boolean hasEqn(Eqn e) {
        int i = e.flatInx();
        if (i >= this.hasEqn.length) {
            return false;
        }
        return this.hasEqn[i];
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.hasEqn.length; ++i) {
            if (!this.hasEqn[i]) continue;
            Eqn eqn = this.math.eqn.eqn(i);
            s = s + "\t" + eqn.toString() + "\n";
        }
        return s;
    }

    public String diagInfo() {
        return this.toString();
    }
}

