/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.aserver.ASConstraint;
import JSim.data.NamedVal;
import JSim.mml.CommonFunc;
import JSim.mml.Comp;
import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.Sys;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.XFunc;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.io.PrintStream;
import java.util.ArrayList;

public class MathSys
extends Sys {
    protected Var.List flatVars;
    protected boolean isFlat;

    public MathSys(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
    }

    public void registerChild(Comp c) throws Xcept {
        super.registerChild(c);
        if (!this.isFlat) {
            return;
        }
        if (!Var.class.isInstance((Object)c)) {
            throw new Xcept((DiagInfo)c, "Non-variable created within flat MathSys");
        }
        this.setFlat((Var)c);
    }

    public void setFlat(Var v) throws Xcept {
        if (v.flatInx != 0) {
            throw new Xcept((DiagInfo)v, "duplicate setFlat index");
        }
        v.flatInx = this.flatVars.size();
        this.flatVars.add((Object)v);
    }

    public boolean isFlattenable() {
        for (int i = 0; i < this.child.size(); ++i) {
            Comp c = this.child.comp(i);
            if (Var.class.isInstance((Object)c)) continue;
            return false;
        }
        return true;
    }

    public void setFlat() throws Xcept {
        int i;
        if (this.isFlat) {
            return;
        }
        this.flatVars = new Var.List(this.child.size());
        for (i = 0; i < this.child.size(); ++i) {
            Comp c = this.child.comp(i);
            if (!Var.class.isInstance((Object)c)) {
                return;
            }
            this.setFlat((Var)c);
            if (!Domain.class.isInstance((Object)c)) continue;
            Domain x = (Domain)c;
            this.setFlat(x.vmin);
            this.setFlat(x.vmax);
            this.setFlat(x.vct);
            this.setFlat(x.vdelta);
        }
        i = 0;
        while (i < this.eqn.size()) {
            Eqn e = this.eqn.eqn(i);
            e.flatInx = i++;
        }
        this.isFlat = true;
    }

    public void writeFlat(PrintStream out, Context ctxt) throws Xcept {
        boolean isTop;
        boolean bl = isTop = this.parent.parent == null;
        if (isTop) {
            out.println("math " + this.name + " {");
        }
        super.writeFlat(out, ctxt);
        if (isTop) {
            out.println("}");
        }
    }

    public int nVar() {
        if (!this.isFlat) {
            throw new Error("MathSys is not flat (nVar)");
        }
        return this.flatVars.size();
    }

    public Var var(int i) throws Error {
        if (!this.isFlat) {
            throw new Error("MathSys is not flat (var)");
        }
        return (Var)this.flatVars.comp(i);
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public Known createKnown() throws Xcept {
        Known known = new Known(this.nVar() + 1);
        for (int i = 0; i < this.nVar(); ++i) {
            known.addVar((NamedExpr)this.var(i));
        }
        return known;
    }

    public NamedVal.NList getProperties() throws Xcept {
        int i;
        NamedVal.NList nvals = new NamedVal.NList();
        CompProp.List defProps = this.getModel().defProps;
        int psz = defProps.size();
        String[] dprops = new String[psz + 1];
        for (i = 0; i < psz; ++i) {
            dprops[i] = defProps.prop((int)i).name;
        }
        dprops[psz] = "calc";
        nvals.add((Named)NamedVal.create((String)"VarProperties", (String[])dprops));
        for (i = 0; i < this.nVar(); ++i) {
            Var v = this.var(i);
            for (int j = 0; j < v.props.size(); ++j) {
                String key = v.toString() + "." + v.props.prop((int)j).name;
                String value = v.props.prop(j).stringVal(null);
                if (value == null) continue;
                nvals.add((Named)NamedVal.create((String)key, (String)value));
            }
        }
        return nvals;
    }

    public ASConstraint.Info[] getConstraints() throws Xcept {
        ASConstraint.EqnInfo info;
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 0; i < this.eqn.size(); ++i) {
            Eqn e = this.eqn.eqn(i);
            info = new ASConstraint.EqnInfo();
            info.eqn_sdom = e.sdom().isEntire() ? null : e.subdom().toString();
            Expr expr = e.expr();
            info.expr = expr.toString();
            info.vall = this.varray(expr);
            list.add(info);
        }
        for (i = 0; i < this.events.size(); ++i) {
            list.add(this.events.event(i).constraintInfo());
        }
        for (i = 0; i < this.voidFuncCalls.size(); ++i) {
            Expr expr = this.voidFuncCalls.expr(i);
            info = new ASConstraint.EqnInfo();
            info.expr = expr.toString();
            if (info.expr.startsWith("xsinit.1[")) {
                info.expr = "xsinit.1[...]";
            }
            if (info.expr.startsWith("xsloop.1[")) {
                info.expr = "xsloop.1[...]";
            }
            if (info.expr.startsWith("xscomp.1[")) {
                info.expr = "xscomp.1[...]";
            }
            info.vall = this.varray(expr);
            XFunc xfunc = ((XFuncCall)expr).func();
            if (xfunc instanceof CommonFunc) {
                int n = ((CommonFunc)xfunc).ninputs();
                info.vout = new String[info.vall.length - n];
                for (int j = n; j < info.vall.length; ++j) {
                    info.vout[j - n] = info.vall[j];
                }
            }
            list.add(info);
        }
        ASConstraint.Info[] infos = new ASConstraint.Info[list.size()];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            infos[i2] = (ASConstraint.Info)list.get(i2);
        }
        return infos;
    }

    private String[] varray(Expr expr) throws Xcept {
        if (expr == null) {
            return null;
        }
        Expr.List vlist = new Expr.List();
        expr.addNamedExpr(vlist);
        if (vlist.size() == 0) {
            return null;
        }
        return vlist.stringList().array();
    }
}

