/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.ClassFunc;
import JSim.mml.CommonFunc;
import JSim.mml.Comp;
import JSim.mml.CompProp;
import JSim.mml.CompTempl;
import JSim.mml.Eqn;
import JSim.mml.Event;
import JSim.mml.Integral;
import JSim.mml.IntegralAt;
import JSim.mml.Model;
import JSim.mml.ModelParser;
import JSim.mml.ModelScanner;
import JSim.mml.NativeFunc;
import JSim.mml.Range;
import JSim.mml.SourceFunc;
import JSim.mml.Summation;
import JSim.mml.Templ;
import JSim.util.CompareExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.NamedExpr;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.XFunc;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import JSim.util.XceptPos;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

public class ModelReader
extends Model {
    private String filename;
    protected Comp comp;
    protected Expr sd;
    protected Event wevent;
    protected XFunc wfunc;
    private Templ wtempl;
    private int waccess;
    public ModelScanner scan;

    public ModelReader(String s) throws Xcept {
        this(new File(s), null, ModelReader.defaultImportPath());
    }

    public ModelReader(File file, ClassLoader cload, String ipath) throws Xcept {
        super(cload, ipath);
        this.filename = file.toString();
        try {
            FileReader rdr = new FileReader(file);
            this.common(rdr);
            rdr.close();
        }
        catch (Exception e) {
            throw new Xcept(e.toString() + "file name <" + file + ">");
        }
    }

    public ModelReader(Reader rdr, ClassLoader cload, String ipath) throws Xcept {
        super(cload, ipath);
        this.filename = null;
        this.common(rdr);
    }

    private void common(Reader rdr) throws Xcept {
        this.comp = this;
        this.scan = new ModelScanner(rdr);
        ModelParser pars = new ModelParser(this.scan);
        pars.mr = this;
        try {
            pars.parse();
        }
        catch (Exception e) {
            XceptPos pos = this.currPos();
            if (!(e instanceof Xcept)) {
                throw new Xcept(e.toString(), pos);
            }
            Xcept xe = (Xcept)((Object)e);
            pos.child = xe.pos;
            xe.pos = pos;
            throw xe;
        }
    }

    public static String defaultImportPath() throws Xcept {
        String path = System.getProperty("jsim.path");
        if (!Util.isBlank((String)path)) {
            return path;
        }
        return System.getProperty("user.home") + File.separator + ".jsim" + File.separator + "local" + File.pathSeparator + Util.jsimHome() + File.separator + "local" + File.pathSeparator + Util.jsimHome() + File.separator + "common" + File.pathSeparator + ".";
    }

    protected void version(String s) throws Xcept {
        if (s == null) {
            return;
        }
        if (s.equals("v1.0") || !s.startsWith("v1.")) {
            throw new Xcept("JSim " + s + " is not an MML version supported by this program");
        }
    }

    protected void importLib(String s) throws Xcept {
        int i;
        String fname = UtilIO.pathFind((String)(s + ".mod"), (String)this.importPath);
        ModelReader m = new ModelReader(new File(fname), this.classLoader, this.importPath);
        this.units.merge(m.units);
        for (i = 0; i < m.templ.size(); ++i) {
            Templ t1 = m.templ.templ(i);
            Templ t0 = this.templ.templ(t1.name());
            if (t0 == null) {
                t1.clone(this);
                continue;
            }
            if (t0.isCompatible(t1)) continue;
            throw new Xcept((DiagInfo)this, "Incompatible definitions for template " + t1.name());
        }
        for (i = 0; i < m.xfuncs.size(); ++i) {
            XFunc f = m.xfuncs.xfunc(i);
            this.registerXFunc(f);
        }
    }

    protected void setUnitControl(String s) throws Xcept {
        if (this.unitControl != 0) {
            throw new Xcept("Multiple unit conversion statements unsupported");
        }
        if (s.equals("off")) {
            this.unitControl = 1;
        } else if (s.equals("on")) {
            this.unitControl = 2;
        } else {
            throw new Xcept("Unsupport unit conversion keyword " + s);
        }
    }

    protected void addExternCode(String j, String txt) throws Xcept {
        if (!j.equals("java")) {
            throw new Xcept((DiagInfo)this, "extern code must be java");
        }
        this.externJava.add((Object)txt);
    }

    protected void newXFunc(String ftype, String dtype, String name, StringList pstr) throws Xcept {
        int dataType;
        if (dtype.equals("void")) {
            dataType = 1;
        } else if (dtype.equals("real")) {
            dataType = 4;
        } else {
            throw new Xcept((DiagInfo)this, "Illegal data type \"" + dtype + "\" for function " + name);
        }
        if (ftype.equals("class")) {
            if (pstr != null) {
                throw new Xcept("class function/procedure declaration for " + name + " should have no argument list");
            }
            this.wfunc = new ClassFunc(name, dataType, null, this.classLoader);
            return;
        }
        if (pstr == null) {
            throw new Xcept("function/procedure declaration for " + name + " missing required argument list");
        }
        if (ftype.equals("native")) {
            this.wfunc = new NativeFunc(name, dataType, pstr);
        } else if (ftype.equals("source")) {
            this.wfunc = new SourceFunc(name, dataType, pstr);
        } else {
            throw new Xcept((DiagInfo)this, "Unsupported function type \"" + ftype + "\" for function " + name);
        }
    }

    protected void doneXFunc() throws Xcept {
        this.wfunc.validate();
        this.registerXFunc(this.wfunc);
        this.wfunc = null;
    }

    protected void addXFuncCode(String n, String code) throws Xcept {
        if (n.equals("reentrant")) {
            this.wfunc.setReentrant(Util.toBoolean((String)code));
        } else if (this.wfunc instanceof CommonFunc) {
            ((CommonFunc)this.wfunc).addCode(n, code);
        } else if (this.wfunc instanceof ClassFunc) {
            ((ClassFunc)this.wfunc).addCode(n, code);
        } else {
            throw new Xcept((DiagInfo)this.wfunc, "Unsupported XFunc class");
        }
    }

    protected void newCompTempl(String n, String tname, StringList parms) throws Xcept {
        CompTempl ct = new CompTempl(this, n, tname, parms);
        this.comp = ct.comp;
    }

    protected void doneCompTempl() {
        this.comp = this;
    }

    protected void setTempl(String t, int acc) throws Xcept {
        this.wtempl = this.getTempl(t);
        this.waccess = acc;
    }

    protected Comp.List listAccess(Comp.List l, String n) throws Xcept {
        NamedExpr e;
        if (l == null) {
            l = new Comp.List(1);
        }
        if ((e = this.comp.getNamed(n)) == null) {
            throw new Xcept((DiagInfo)this.comp, n + " not found");
        }
        if (!(e instanceof Comp)) {
            throw new Xcept((DiagInfo)e, "property not valid here");
        }
        l.add(e);
        return l;
    }

    protected void setAccess(Comp.List list, int acc) throws Xcept {
        for (int i = 0; i < list.size(); ++i) {
            list.comp(i).setAccess(acc);
        }
    }

    protected void parseComp(String n, Expr.List e) throws Xcept {
        NamedExpr ne = this.comp.getNamed(n);
        if (ne != null && !(ne instanceof Comp)) {
            throw new Xcept((DiagInfo)ne, "incompatible property definition");
        }
        Comp c = (Comp)ne;
        if (c == null) {
            c = this.wtempl.createComp(this.comp, n, e);
            c.templ = this.wtempl;
            c.builtin = false;
        }
        if (c.templ != this.wtempl || c.args != e) {
            throw new Xcept((DiagInfo)c, "Incompatible definitions for " + c.fullName() + " c.templ=" + c.templ + " wtempl=" + this.wtempl + " cargs=" + c.args + " e=" + e);
        }
        c.setAccess(this.waccess);
        this.comp = c;
    }

    protected void doneComp() throws Xcept {
        this.comp = this.comp.parent;
    }

    protected Expr makeIntegral(Range r, Expr u) throws Xcept {
        return new Integral(this.comp, r, u);
    }

    protected Expr makeIntegral(Expr u) throws Xcept {
        return new IntegralAt(this.comp, u);
    }

    protected Summation makeSum(Range r, Expr u) throws Xcept {
        return new Summation(this.comp, r, u);
    }

    protected Summation makeSum(Expr u) throws Xcept {
        return new Summation(this.comp, u);
    }

    protected void beginEvent(Expr trig) throws Xcept {
        this.wevent = new Event(this.comp, trig);
    }

    protected void endEvent() {
        this.wevent = null;
    }

    protected void addDefProp(String name, String stype) throws Xcept {
        int type = -1;
        if (!stype.equals("string")) {
            throw new Xcept((DiagInfo)this, "Property " + name + ": only string type is currently supported.");
        }
        type = 8;
        this.defProps.add((Object)new CompProp(this, name, type));
    }

    protected void addEqn(Expr rhx, Unit u) throws Xcept {
        if (u != null && !rhx.isConst()) {
            throw new Xcept((DiagInfo)this.comp, "Constant expression required with unit");
        }
        Comp e = this.comp;
        if (e.dataType() != rhx.dataType()) {
            throw new Xcept((DiagInfo)e, (DiagInfo)rhx, "mismatched dataTypes");
        }
        Eqn eqn = new Eqn(this.comp.parent, null, (Expr)e, 41, rhx);
        eqn.pos = this.currPos();
        eqn.builtin = false;
        if (u != null) {
            this.comp.setUnit(u);
        }
    }

    protected void addStmt(Expr e) throws Xcept {
        if (this.wevent != null) {
            this.wevent.addEqn(e);
            return;
        }
        Expr.List exprs = new Expr.List(4);
        e.addNamedExpr(exprs);
        CompProp p = null;
        for (int i = 0; i < exprs.size(); ++i) {
            if (!(exprs.expr(i) instanceof CompProp)) continue;
            p = (CompProp)exprs.expr(i);
        }
        if (p != null) {
            p.setStmt(e);
        } else if (e instanceof CompareExpr) {
            Eqn eqn = Eqn.create(this.comp, this.sd, e, this.currPos());
            eqn.builtin = false;
        } else if (e instanceof XFuncCall) {
            ((XFuncCall)e).setSD(this.sd);
            this.comp.voidFuncCalls.add((Object)e);
        } else {
            throw new Xcept((DiagInfo)e, "Equation, relation or void function call expected");
        }
    }

    protected void doneTempl() {
        this.wtempl = null;
        this.waccess = 0;
    }

    public XceptPos currPos() {
        return new XceptPos(this.filename, this.scan.getLineNo(), this.scan.getCharNo(), this.scan.tokText());
    }

    public Expr compByName(String n) throws Xcept {
        return this.compByName(this.comp, n);
    }

    public Expr funcCall(String n, Expr.List elist) throws Xcept {
        return this.funcCall(this.comp, n, elist);
    }

    public void classOverride(String cname, String ocname) throws Xcept {
        throw new Xcept("MML override is not currently supported");
    }
}

