/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.CommonFunc;
import JSim.mml.Comp;
import JSim.util.DiagInfo;
import JSim.util.StringList;
import JSim.util.Util;
import JSim.util.XFunc;
import JSim.util.Xcept;
import java.io.PrintStream;

public class NativeFunc
extends CommonFunc {
    public NativeFunc(String n, int dtype, StringList pstr) throws Xcept {
        super(n, 2, dtype, pstr);
    }

    public void addCode(String n, String s) throws Xcept {
        if (n.equals("language")) {
            this.setLang(s);
        } else if (n.equals("library")) {
            this.libName = s;
            this.validateName(s);
        } else if (n.equals("name")) {
            this.funcName = s;
            this.validateName(s);
        } else {
            throw new Xcept((DiagInfo)this, "unrecognized keyword \"" + n + "\"");
        }
    }

    private void setLang(String s) throws Xcept {
        int l = 0;
        if (!s.equals("C")) {
            throw new Xcept((DiagInfo)this, "Language \"" + s + "\" not supported for native functions");
        }
        l = 5;
        if (this.lang() != 0 && this.lang() != l) {
            throw new Xcept((DiagInfo)this, "ambiguous language specification");
        }
        this.setLang(l);
    }

    public void validate() throws Xcept {
        if (this.lang() == 0) {
            throw new Xcept((DiagInfo)this, "language undefined");
        }
        if (this.libName == null) {
            throw new Xcept((DiagInfo)this, "library undefined");
        }
        if (this.funcName == null) {
            throw new Xcept((DiagInfo)this, "name undefined");
        }
    }

    public boolean sameAs(XFunc f) {
        if (!(f instanceof NativeFunc)) {
            return false;
        }
        NativeFunc f1 = (NativeFunc)f;
        if (!NativeFunc.sameStr((String)this.libName, (String)f1.libName)) {
            return false;
        }
        if (!NativeFunc.sameStr((String)this.funcName, (String)f1.funcName)) {
            return false;
        }
        return super.sameAs((XFunc)f1);
    }

    public void validateName(String s) throws Xcept {
        if (!Util.onlyLettersAndDigits((String)s)) {
            throw new Xcept((DiagInfo)this, "name \"" + s + "\" may contain only alphanumerics");
        }
        Comp.validateName((DiagInfo)this, s);
    }

    public void writeFlat(PrintStream out) {
        out.println(this.flatHdr());
        out.println("\tlanguage=\"" + this.langName() + "\";");
        out.println("\tlibrary=\"" + this.libName + "\";");
        out.println("\tname=\"" + this.funcName + "\";");
        out.println("}");
    }
}

