/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.NVar;
import JSim.mml.Var;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.PrettyUnit;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;

public class RealNVar
extends NVar {
    private RealNVar underiv;
    private Domain derivdomain;

    public RealNVar(Comp p, String n, Expr.List d) throws Xcept {
        super(p, n, d);
    }

    public Var createDeriv(Domain t) throws Xcept {
        if (!this.hasDomain(t)) {
            throw new Xcept((DiagInfo)this, "variable has no derivate wrt " + t.name);
        }
        String n = this.name + ":" + t.name;
        RealNVar v = new RealNVar(this.parent, n, this.args);
        v.underiv = this;
        if (this.unit != null) {
            Unit u2 = t.unit == null ? this.unit : PrettyUnit.unit((Unit)this.unit.deriv(t.unit));
            v.setUnit(u2);
        }
        v.derivdomain = t;
        if (this.isPrivate()) {
            v.setAccess(2);
        }
        Util.verbose((String)("Creating deriv variable " + v.toString()));
        return v;
    }

    public Var unDeriv() throws Xcept {
        if (this.underiv == null) {
            throw new Xcept((DiagInfo)this, "no unDeriv() for this var");
        }
        return this.underiv;
    }

    public Domain derivDomain() throws Xcept {
        if (this.derivdomain == null) {
            throw new Xcept((DiagInfo)this, "no derivDomain() for this var");
        }
        return this.derivdomain;
    }
}

