/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.CommonFunc;
import JSim.util.DiagInfo;
import JSim.util.StringList;
import JSim.util.XFunc;
import JSim.util.Xcept;
import java.io.PrintStream;

public class SourceFunc
extends CommonFunc {
    private String topCode;
    private String mainCode;
    private String bottomCode;
    private String flags;
    private String library;
    private String name;

    public SourceFunc(String n, int dtype, StringList pstr) throws Xcept {
        super(n, 3, dtype, pstr);
    }

    public void addCode(String n, String code) throws Xcept {
        if (n.equals("language")) {
            this.setLang(code);
        } else if (n.equals("topcode")) {
            this.topCode = code;
        } else if (n.equals("maincode")) {
            this.mainCode = code;
        } else if (n.equals("bottomcode")) {
            this.bottomCode = code;
        } else if (n.equals("flags")) {
            this.flags = code;
        } else {
            throw new Xcept((DiagInfo)this, "unrecognized keyword \"" + n + "\"");
        }
    }

    private void setLang(String s) throws Xcept {
        int l = 0;
        if (s.equals("java")) {
            l = 4;
        } else if (s.equals("C")) {
            l = 5;
        } else {
            throw new Xcept((DiagInfo)this, "Language \"" + s + "\" not supported");
        }
        if (this.lang() != 0 && this.lang() != l) {
            throw new Xcept((DiagInfo)this, "ambiguous language specification");
        }
        this.setLang(l);
    }

    public void validate() throws Xcept {
        if (this.lang() == 0) {
            throw new Xcept((DiagInfo)this, "language undefined");
        }
        if (this.mainCode == null) {
            throw new Xcept((DiagInfo)this, "maincode undefined");
        }
        if (this.lang() == 4 && this.flags != null) {
            throw new Xcept((DiagInfo)this, "java compiler flags are not supported");
        }
    }

    public String topCode() {
        return this.topCode;
    }

    public String mainCode() {
        return this.mainCode;
    }

    public String bottomCode() {
        return this.bottomCode;
    }

    public String flags() {
        return this.flags;
    }

    public boolean sameAs(XFunc f) {
        if (!(f instanceof SourceFunc)) {
            return false;
        }
        SourceFunc f1 = (SourceFunc)f;
        if (!SourceFunc.sameStr((String)this.topCode, (String)f1.topCode)) {
            return false;
        }
        if (!SourceFunc.sameStr((String)this.mainCode, (String)f1.mainCode)) {
            return false;
        }
        if (!SourceFunc.sameStr((String)this.bottomCode, (String)f1.bottomCode)) {
            return false;
        }
        if (!SourceFunc.sameStr((String)this.flags, (String)f1.flags)) {
            return false;
        }
        return super.sameAs((XFunc)f1);
    }

    public void setLibrary(String l, String f) {
        this.libName = l;
        this.funcName = f;
    }

    public void writeFlat(PrintStream out) {
        out.println(this.flatHdr());
        out.println("\tlanguage=\"" + this.langName() + "\";");
        if (this.flags != null) {
            out.println("\tflags=\"" + this.flags + "\";");
        }
        if (this.topCode != null) {
            out.println("\ttopcode={{" + this.topCode + "}};");
        }
        out.println("\tmaincode={{" + this.mainCode + "}};");
        if (this.bottomCode != null) {
            out.println("\tbottomcode={{" + this.bottomCode + "}};");
        }
        out.println("}");
    }
}

