/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.Model;
import JSim.mml.Range;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.ForallExpr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class Summation
extends Expr {
    private Comp comp;
    private Domain t;
    private Expr min;
    private Expr max;
    private Expr u;
    private Domain.List domains;
    private Var v;
    public static final String SSUM = "sum";

    public Summation(Comp c, Expr expr) throws Xcept {
        this.comp = c;
        if (!(expr instanceof ForallExpr)) {
            throw new Xcept("sum missing @");
        }
        ForallExpr fexpr = (ForallExpr)expr;
        if (!(fexpr.domain() instanceof Domain)) {
            throw new Xcept((DiagInfo)fexpr, "sum must be over domain");
        }
        this.t = (Domain)fexpr.domain();
        this.min = this.t.vmin;
        this.max = this.t.vmax;
        this.u = fexpr.base();
        this.common();
    }

    public Summation(Comp c, Range r, Expr uu) throws Xcept {
        this.comp = c;
        Comp ct = c.getChild(r.t);
        if (!(ct instanceof Domain)) {
            throw new Xcept("Invalid sum domain: " + r.t);
        }
        this.t = (Domain)ct;
        this.min = r.min;
        this.max = r.max;
        this.u = uu;
        if (this.min != this.t.vmin || this.max != this.t.vmax) {
            throw new Xcept("sum range not yet supported: " + r);
        }
        this.common();
    }

    private void common() throws Xcept {
        if (this.u instanceof ForallExpr) {
            throw new Xcept("sum does not support nested @'s");
        }
        this.domains = new Domain.List(2);
        this.u.addDomains((Expr.List)this.domains);
        this.domains.sub((Expr)this.t);
        this.min.addDomains((Expr.List)this.domains);
        this.max.addDomains((Expr.List)this.domains);
        if (this.domains.containSame((Expr)this.t)) {
            this.domains.sub((Expr)this.t);
            this.domains.add((Object)this.t);
        }
        String vname = "sum__call" + this.comp.getModel().newScratch();
        this.v = new RealNVar(this.comp, vname, this.domains);
        this.v.setAccess(2);
        Model model = this.comp.getModel();
        Expr.List args = new Expr.List(1);
        args.add((Object)new ForallExpr(this.u, (Expr)this.t));
        Expr xsum = model.funcCall(this.comp, SSUM, args);
        new Eqn(this.comp, null, (Expr)this.v, 41, xsum);
    }

    public int dataType() {
        return 4;
    }

    public Domain t() {
        return this.t;
    }

    public Expr min() {
        return this.min;
    }

    public Expr max() {
        return this.max;
    }

    public Expr u() {
        return this.u;
    }

    public boolean sameAs(Expr e) {
        if (!(e instanceof Summation)) {
            return false;
        }
        Summation ei = (Summation)e;
        return this.t.sameAs((Expr)ei.t) && this.min.sameAs(ei.min) && this.max.sameAs(ei.max) && this.u.sameAs(ei.u);
    }

    public void addNamedExpr(Expr.List list) throws Xcept {
        this.t.addNamedExpr(list);
        this.min.addNamedExpr(list);
        this.max.addNamedExpr(list);
        this.u.addNamedExpr(list);
    }

    public void addDomains(Expr.List list) {
        list.addUniq((Expr.List)this.domains);
    }

    public boolean hasUnit() {
        return true;
    }

    public Unit unit() {
        return this.u.unit();
    }

    public Expr unitCorrect() throws Xcept {
        this.min = this.min.unitCorrect();
        this.max = this.max.unitCorrect();
        this.u = this.u.unitCorrect();
        return this;
    }

    public Expr expandDeriv() throws Xcept {
        return this;
    }

    public Expr takeDomDeriv(NamedExpr t) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDomDeriv not implemented");
    }

    public Expr calculable(Known known) throws Xcept {
        return this.v.calculable(known);
    }

    public Expr simplify(Known known) throws Xcept {
        return this;
    }

    public String toString() {
        return "sum(" + (Object)((Object)this.t) + "," + this.min + "," + this.max + "," + this.u + ")";
    }

    public String toString(Context ctxt) {
        return this.v.toString(ctxt);
    }
}

