/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.Model;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;
import java.io.PrintStream;

public abstract class Var
extends Comp {
    protected Unit unit;
    protected int flatInx;

    public int flatInx() {
        return this.flatInx;
    }

    public int nDeriv() {
        char[] c = this.name.toCharArray();
        int ct = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != ':') continue;
            ++ct;
        }
        return ct;
    }

    public Var(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        for (int i = 0; i < this.getModel().defProps.size(); ++i) {
            CompProp prop = this.getModel().defProps.prop(i);
            this.addProp(prop.name(), prop.dataType());
        }
    }

    public int dataType() {
        return 4;
    }

    public boolean isVar() {
        return true;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isState() {
        return false;
    }

    public boolean hasUnit() {
        return true;
    }

    public Unit unit() {
        return this.unit;
    }

    public void setUnit(Unit u) throws Xcept {
        if (u != null && this.getModel().unitControl == 0) {
            throw new Xcept("Units not allowed in this model");
        }
        this.unit = u;
    }

    public abstract int ndim();

    public abstract Domain domain(int var1);

    public abstract boolean hasDomain(Var var1);

    public Domain.List domainList() {
        Domain.List dlist = new Domain.List(this.ndim());
        this.addDomains(dlist);
        return dlist;
    }

    public void addDomains(Expr.List dlist) {
        for (int i = 0; i < this.ndim(); ++i) {
            dlist.addUniq((Expr)this.domain(i));
        }
    }

    public Var deriv(Var t) throws Xcept {
        return this.deriv(t, true);
    }

    public Var deriv(Var t, boolean makeit) throws Xcept {
        String n = this.name + ":" + t.name;
        Comp c = this.parent.getChild(n);
        if (c == null) {
            if (!t.isDomain()) {
                throw new Xcept((DiagInfo)this, t.name + " is not domain,  cannot make deriv var");
            }
            return makeit ? this.createDeriv((Domain)t) : null;
        }
        if (!c.isVar()) {
            throw new Xcept((DiagInfo)this, "Var.deriv() is not Var");
        }
        return (Var)c;
    }

    public Var createDeriv(Domain t) throws Xcept {
        throw new Xcept((DiagInfo)this, "Cannot create derivative for this variable class");
    }

    public Var unDeriv() throws Xcept {
        throw new Xcept((DiagInfo)this, "no unDeriv() for this var");
    }

    public boolean isDeriv() {
        return this.name.indexOf(58) >= 0;
    }

    public Var zeroDeriv() throws Xcept {
        Var v = this;
        while (v.isDeriv()) {
            v = v.unDeriv();
        }
        return v;
    }

    public Domain derivDomain() throws Xcept {
        throw new Xcept((DiagInfo)this, "no derivDomain() for this var");
    }

    public void writeFlat(PrintStream out, Context ctxt) throws Xcept {
        Model m = this.getModel();
        String s = null;
        if (m.realTempl.clss().isInstance((Object)this)) {
            s = "real";
        } else if (m.realDomainTempl.clss().isInstance((Object)this)) {
            s = "realDomain";
        } else if (m.choiceTempl.clss().isInstance((Object)this)) {
            s = "choice";
        } else if (m.intTempl.clss().isInstance((Object)this)) {
            s = "int";
        }
        if (this.isDeriv()) {
            s = null;
        }
        if (s != null) {
            out.println("\t" + this.accessString() + s + " " + this.toString(ctxt) + (this.args == null ? "" : this.args.toString(ctxt)) + (this.unit == null ? "" : " " + this.unit.pubName()) + ";");
        }
        for (int i = 0; i < this.getModel().defProps.size(); ++i) {
            String pname = this.getModel().defProps.prop(i).name();
            String pval = this.prop(pname).constStringVal();
            if (pval == null) continue;
            out.println("\t" + this.toString(ctxt) + "." + pname + "=\"" + pval + "\";");
        }
        super.writeFlat(out, ctxt);
    }

    public static class List
    extends Comp.List {
        public List(int n) {
            super(n);
        }

        public List(Expr e) throws Xcept {
            super(e);
        }

        public Var var(int i) {
            return (Var)((Object)this.get(i));
        }

        public Domain.List domainList() {
            Domain.List list = new Domain.List(1);
            for (int i = 0; i < this.size(); ++i) {
                Var v = this.var(i);
                list.addUniq(v.domainList());
            }
            return list;
        }

        public List zeroDeriv() throws Xcept {
            List list = new List(this.size());
            for (int i = 0; i < this.size(); ++i) {
                list.addUniq((Expr)this.var(i).zeroDeriv());
            }
            return list;
        }
    }
}

