/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.nml.ode1.ODE1SolverDopri5;
import JSim.nml.ode1.ODE1SolverRadau;
import JSim.util.Xcept;

public class ODE1SolverAuto
extends ODE1Slave {
    private ODE1SolverDopri5 dopri5;
    private ODE1SolverRadau radau;
    private boolean useRadau;

    public ODE1SolverAuto(ODE1Solver s) throws Xcept {
        super(s, "Adaptive (Dopri5/Radau)");
        this.dopri5 = new ODE1SolverDopri5(s);
        this.radau = new ODE1SolverRadau(s);
        this.useRadau = false;
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int neqn = y0.length;
        double[] ydot = new double[neqn];
        for (int i = 0; i < neqn; ++i) {
            yend[i] = y0[i];
        }
        if (!this.useRadau) {
            int idid = this.dopri5.solve0(ctxt, x0, xend, y0, yend);
            switch (idid) {
                case -4: 
                case -3: 
                case -2: {
                    this.useRadau = true;
                    break;
                }
                case -5: 
                case -1: {
                    throw new Xcept("Solver Error: Dopri5 - " + ODE1SolverDopri5.status(idid));
                }
            }
        }
        if (this.useRadau) {
            this.radau.solve(ctxt, x0, xend, y0, yend);
        }
    }
}

