/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Callbacks;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public class ODE1SolverDopri5
extends ODE1Slave {
    private double rtol = this.realVal("ode_Dopri5_reltol");
    private double atol = this.realVal("ode_Dopri5_abstol");
    private long nmax = this.intVal("ode_Dopri5_nstep");
    private long nstiff = this.intVal("ode_Dopri5_stiff");
    private double uround = this.realVal("ode_Dopri5_round");
    private double safe = this.realVal("ode_Dopri5_safety");
    private double fac1 = this.realVal("ode_Dopri5_loselect");
    private double fac2 = this.realVal("ode_Dopri5_hiselect");
    private double beta = this.realVal("ode_Dopri5_beta");

    public ODE1SolverDopri5(ODE1Solver s) throws Xcept {
        super(s, "Dopri5 (non-stiff)");
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int idid = this.solve0(ctxt, x0, xend, y0, yend);
        if (idid < 0) {
            throw new Xcept("Solver Error: Dopri5 - " + ODE1SolverDopri5.status(idid));
        }
    }

    public static String status(int idid) {
        switch (idid) {
            case -1: {
                return "input is not consistent";
            }
            case -2: {
                return "larger internal nmax array needed";
            }
            case -3: {
                return "step size becomes too small";
            }
            case -4: {
                return "problem is probably too stiff";
            }
            case -5: {
                return "NaNs detected during evaluation";
            }
        }
        return "undocumented exit status=" + idid;
    }

    public int solve0(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int neqn = y0.length;
        double[] ydot = new double[neqn];
        for (int i = 0; i < neqn; ++i) {
            yend[i] = y0[i];
        }
        int idid = this.jdopri5(ctxt.threadInx, ctxt, neqn, x0, xend, yend, ydot, this.rtol, this.atol, this.nmax, this.nstiff, this.uround, this.safe, this.fac1, this.fac2, this.beta, this.callbacks());
        this.callbacks().evaluate(ctxt, x0, y0, ydot);
        return idid;
    }

    public native int jdopri5(int var1, RTContext var2, int var3, double var4, double var6, double[] var8, double[] var9, double var10, double var12, long var14, long var16, double var18, double var20, double var22, double var24, double var26, ODE1Callbacks var28) throws Xcept;

    static {
        System.loadLibrary("odesolver");
    }
}

