/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public class ODE1SolverEuler
extends ODE1Slave {
    private int nStep = this.intVal("ode_Euler_nstep");

    public ODE1SolverEuler(ODE1Solver s) throws Xcept {
        super(s, "Euler");
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int i;
        int n = y0.length;
        double x = x0;
        double[] ydot = new double[n];
        double[] ystar = new double[n];
        double[] f1 = new double[n];
        double stepSize = (xend - x0) / (double)this.nStep;
        double eps = stepSize * 0.1;
        for (i = 0; i < n; ++i) {
            yend[i] = y0[i];
        }
        while (x < xend - eps) {
            this.callbacks().evaluate(ctxt, x, yend, ydot);
            for (i = 0; i < n; ++i) {
                f1[i] = ydot[i];
                yend[i] = yend[i] + stepSize * f1[i];
                if (!Double.isInfinite(yend[i]) && !Double.isNaN(yend[i])) continue;
                throw new Xcept("Solver Euler failed on variable #" + i + " ydot=" + ydot[i] + " stepSize=" + stepSize + " f1=" + f1[i]);
            }
            x += stepSize;
        }
        this.callbacks().evaluate(ctxt, x0, y0, ydot);
    }
}

