/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public class ODE1SolverFehlberg
extends ODE1Slave {
    private double minStepSize = this.realVal("ode_Fehlberg_minstep");
    private double maxStepSize = this.realVal("ode_Fehlberg_maxstep");
    private double tol = this.realVal("ode_Fehlberg_tol");

    public ODE1SolverFehlberg(ODE1Solver s) throws Xcept {
        super(s, "Fehlberg");
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int i;
        double stepSize;
        int n = y0.length;
        double x = x0;
        double[] ydot = new double[n];
        double[] yi = new double[n];
        double[] yrk4 = new double[n];
        double[] yrk5 = new double[n];
        double[] k1 = new double[n];
        double[] k2 = new double[n];
        double[] k3 = new double[n];
        double[] k4 = new double[n];
        double[] k5 = new double[n];
        double[] k6 = new double[n];
        double[] a1 = new double[n];
        double[] a2 = new double[n];
        double[] r = new double[n];
        double h = stepSize = xend - x0;
        double s = 0.0;
        for (i = 0; i < n; ++i) {
            yend[i] = y0[i];
        }
        while (x < xend) {
            boolean flg = true;
            boolean flg2 = false;
            while (flg) {
                this.callbacks().evaluate(ctxt, x, yend, ydot);
                for (i = 0; i < n; ++i) {
                    k1[i] = h * ydot[i];
                    yi[i] = yend[i] + 0.25 * k1[i];
                }
                this.callbacks().evaluate(ctxt, x + 0.25 * h, yi, ydot);
                for (i = 0; i < n; ++i) {
                    k2[i] = h * ydot[i];
                    yi[i] = yend[i] + 0.03125 * (3.0 * k1[i] + 9.0 * k2[i]);
                }
                this.callbacks().evaluate(ctxt, x + 0.375 * h, yi, ydot);
                for (i = 0; i < n; ++i) {
                    k3[i] = h * ydot[i];
                    yi[i] = yend[i] + 4.551661356395084E-4 * (1932.0 * k1[i] - 7200.0 * k2[i] + 7296.0 * k3[i]);
                }
                this.callbacks().evaluate(ctxt, x + 0.9230769230769231 * h, yi, ydot);
                for (i = 0; i < n; ++i) {
                    k4[i] = h * ydot[i];
                    yi[i] = yend[i] + 2.0324074074074074 * k1[i] - 8.0 * k2[i] + 7.173489278752436 * k3[i] - 0.20589668615984405 * k4[i];
                }
                this.callbacks().evaluate(ctxt, x + h, yi, ydot);
                for (i = 0; i < n; ++i) {
                    k5[i] = h * ydot[i];
                    yi[i] = yend[i] - 0.2962962962962963 * k1[i] + 2.0 * k2[i] - 1.3816764132553607 * k3[i] + 0.4529727095516569 * k4[i] - 0.275 * k5[i];
                }
                this.callbacks().evaluate(ctxt, x + 0.5 * h, yi, ydot);
                for (i = 0; i < n; ++i) {
                    k6[i] = h * ydot[i];
                    yrk4[i] = yend[i] + 0.11574074074074074 * k1[i] + 0.5489278752436647 * k3[i] + 0.5353313840155945 * k4[i] - 0.2 * k5[i];
                    yrk5[i] = yend[i] + 0.11851851851851852 * k1[i] + 0.5189863547758284 * k3[i] + 0.5061314903420167 * k4[i] - 0.18 * k5[i] + 0.03636363636363636 * k6[i];
                }
                for (i = 0; i < n; ++i) {
                    r[i] = Math.abs(yrk4[i] - yrk5[i]) / h;
                }
                double rmax = 0.0;
                for (i = 0; i < n; ++i) {
                    if (Double.isInfinite(r[i]) || Double.isNaN(r[i])) {
                        throw new Xcept("Solver Felhberg failed");
                    }
                    if (!(r[i] > rmax)) continue;
                    rmax = r[i];
                }
                if (rmax > this.tol && !flg2) {
                    s = Math.sqrt(Math.sqrt(Math.abs(this.tol * h / (2.0 * rmax))));
                    if (s < 0.1) {
                        s = 0.1;
                    }
                    if (s > 1.0) {
                        s = 1.0;
                    }
                    if (!((h *= s * h) < this.minStepSize)) continue;
                    flg2 = true;
                    h = this.minStepSize;
                    continue;
                }
                flg = false;
                flg2 = false;
                x += h;
                for (i = 0; i < n; ++i) {
                    yend[i] = yrk4[i];
                }
                h *= 0.9 * Math.sqrt(this.tol / rmax);
                if (!(x + (h = Math.min(Math.max(this.minStepSize, h), this.maxStepSize)) > xend)) continue;
                h = xend - x;
            }
        }
        this.callbacks().evaluate(ctxt, x0, y0, ydot);
    }
}

