/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Xcept;

public class GGopt
extends Optimizer {
    private OptimArgs args;
    private OptimCallbacks cbs;
    private OptimResults res;

    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "ggopt";
        algInfo.boundsNeeded = false;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[]{"stepTol", "maxIters", "gradTol", "eps"};
        algInfo.optimClassName = GGopt.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults r, OptimCallbacks cbs) throws Xcept {
        this.res = r;
        this.args = this.res.args;
        this.cbs = cbs;
        int n = this.args.nx();
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = this.args.xstart[i];
        }
        double[] wk = new double[(1 + n + n * n) * (1 + n + n * (n + 1) / 2)];
        int[] istop = new int[1];
        int mxdim = n;
        int mxcol = 1 + mxdim + mxdim * (mxdim + 1) / 2;
        int mxrow = 1 + mxdim + mxdim * mxdim;
        double[] x0 = new double[mxdim];
        double[] h = new double[mxdim];
        double[] s = new double[mxdim];
        double[] theta = new double[mxcol];
        double[] wk1 = new double[mxrow * (mxdim + 1)];
        double[] wk3 = new double[mxrow];
        double[] wk4 = new double[mxcol];
        try {
            int threadInx = ctxt == null ? 0 : ctxt.threadInx;
            this.ggopt(threadInx, ctxt, n, x, this.args.maxCalls, this.args.maxIters, new double[]{this.args.gradTol}, new double[]{this.args.stepTol}, new double[]{this.args.errTol}, new double[]{this.args.eps}, wk, istop, mxdim, mxcol, mxrow, x0, h, s, theta, wk1, wk3, wk4);
            this.res.status = istop[0];
            this.res.finalStep = Double.NaN;
            switch (this.res.status) {
                case 0: {
                    this.res.status = 3;
                    this.res.termMsg = "Abnormal termination";
                    break;
                }
                case 1: {
                    this.res.status = 1;
                    this.res.termMsg = "Met gradient stopping criterion";
                    break;
                }
                case 2: {
                    this.res.status = 1;
                    this.res.termMsg = "Met relative step stopping criterion";
                    break;
                }
                case 3: {
                    this.res.status = 1;
                    this.res.termMsg = "Met # iterations stopping criterion";
                    break;
                }
                case 4: {
                    this.res.status = 1;
                    this.res.termMsg = "Cannot improve values any further";
                    break;
                }
                case 5: {
                    this.res.status = 1;
                    this.res.termMsg = "Met mean sqr error stopping criterion";
                    break;
                }
                case 6: {
                    this.res.status = 1;
                    this.res.termMsg = "Met # calls stopping criterion";
                    break;
                }
                case 7: {
                    this.res.status = 3;
                    this.res.termMsg = "Error during model evaluation";
                    break;
                }
                case 8: {
                    this.res.status = 3;
                    this.res.termMsg = "Optimization canceled by user";
                    break;
                }
                default: {
                    this.res.status = 3;
                    this.res.termMsg = "Undocumented error code (" + istop[0] + ")";
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof Xcept) {
                Xcept xe = (Xcept)((Object)e);
                this.res.termMsg = xe.cleanMessage();
                throw xe;
            }
            this.res.termMsg = e.getMessage();
            throw new Xcept((DiagInfo)this, this.res.termMsg);
        }
        if (this.res.status == 3) {
            throw new Xcept("GGopt optimizer: " + this.res.termMsg);
        }
    }

    private native void ggopt(int var1, RTContext var2, int var3, double[] var4, int var5, int var6, double[] var7, double[] var8, double[] var9, double[] var10, double[] var11, int[] var12, int var13, int var14, int var15, double[] var16, double[] var17, double[] var18, double[] var19, double[] var20, double[] var21, double[] var22) throws Exception;

    public native void abort(int var1);

    public double fcn(RTContext ctxt, double[] x) {
        try {
            return this.cbs.calcError(ctxt, x, this.res);
        }
        catch (Exception e) {
            int threadInx = ctxt == null ? 0 : ctxt.threadInx;
            this.abort(threadInx);
            return Double.NaN;
        }
    }

    public String diagInfo() {
        return "GGopt Optimizer";
    }

    public boolean allowMP() {
        return false;
    }

    static {
        System.loadLibrary("opt");
    }
}

