/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Xcept;

public class NelderMead
extends Optimizer {
    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "neldermead";
        algInfo.boundsNeeded = false;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[]{"xstep"};
        algInfo.optimClassName = NelderMead.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults res, OptimCallbacks cbs) throws Xcept {
        int i;
        int np;
        int nParam = 0;
        double[] paramValue = null;
        Object paraName = null;
        double functValue = 0.0;
        double minimum = 0.0;
        int prec = 4;
        int field = 13;
        boolean convStatus = false;
        int nMax = 3000;
        int nIter = 0;
        int konvge = 3;
        int kRestart = 0;
        double fTol = 1.0E-13;
        double rCoeff = 1.0;
        double eCoeff = 2.0;
        double cCoeff = 0.5;
        double[] step = null;
        double dStep = 0.5;
        boolean minTest = false;
        double simplexSd = 0.0;
        double[] start = (double[])res.args.xstart.clone();
        step = (double[])res.args.xistep.clone();
        fTol = res.args.errTol;
        nMax = res.args.maxCalls;
        boolean testContract = false;
        nParam = np = start.length;
        convStatus = true;
        int nnp = np + 1;
        if (step.length != start.length) {
            throw new Xcept((DiagInfo)this, "step array length " + step.length + " and initial estimate array length " + start.length + " are of different");
        }
        for (int i2 = 0; i2 < np; ++i2) {
            if (step[i2] != 0.0) continue;
            throw new Xcept((DiagInfo)this, "step " + i2 + " size is zero");
        }
        paramValue = new double[np];
        double[] pmin = new double[np];
        double[][] pp = new double[nnp][nnp];
        double[] yy = new double[nnp];
        double[] pbar = new double[nnp];
        double[] pstar = new double[nnp];
        double[] p2star = new double[nnp];
        nIter = 0;
        double sho = 0.0;
        for (int i3 = 0; i3 < np; ++i3) {
            pstar[i3] = sho = start[i3];
            p2star[i3] = sho;
            pmin[i3] = sho;
        }
        int jcount = konvge;
        for (int i4 = 0; i4 < np; ++i4) {
            for (int j = 0; j < np; ++j) {
                pp[j][i4] = start[i4];
                if (i4 != j) continue;
                double[] dArray = pp[j];
                int n = i4;
                dArray[n] = dArray[n] + step[j];
            }
            pp[nnp - 1][i4] = start[i4];
        }
        this.fcn1(nnp, cbs, ctxt, pp, yy, res);
        double ynewlo = 0.0;
        double ystar = 0.0;
        double y2star = 0.0;
        double ylo = 0.0;
        double curMin = 0.0;
        double sumnm = 0.0;
        double summnm = 0.0;
        double zn = 0.0;
        int ilo = 0;
        int ihi = 0;
        int ln = 0;
        boolean test = true;
        while (test) {
            int i5;
            int j;
            ynewlo = ylo = yy[0];
            ilo = 0;
            ihi = 0;
            for (i = 1; i < nnp; ++i) {
                if (yy[i] < ylo) {
                    ylo = yy[i];
                    ilo = i;
                }
                if (!(yy[i] > ynewlo)) continue;
                ynewlo = yy[i];
                ihi = i;
            }
            for (i = 0; i < np; ++i) {
                zn = 0.0;
                for (int j2 = 0; j2 < nnp; ++j2) {
                    zn += pp[j2][i];
                }
                pbar[i] = (zn -= pp[ihi][i]) / (double)np;
            }
            for (i = 0; i < np; ++i) {
                pstar[i] = (1.0 + rCoeff) * pbar[i] - rCoeff * pp[ihi][i];
            }
            ystar = this.fcn1(cbs, ctxt, pstar, res);
            ++nIter;
            if (ystar < ylo) {
                for (i = 0; i < np; ++i) {
                    p2star[i] = pstar[i] * (1.0 + eCoeff) - eCoeff * pbar[i];
                }
                y2star = this.fcn1(cbs, ctxt, p2star, res);
                ++nIter;
                if (y2star < ylo) {
                    for (i = 0; i < np; ++i) {
                        pp[ihi][i] = p2star[i];
                    }
                    yy[ihi] = y2star;
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[ihi][i] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            } else {
                ln = 0;
                for (i = 0; i < nnp; ++i) {
                    if (i == ihi || !(ystar > yy[i])) continue;
                    ++ln;
                }
                if (ln == np) {
                    if (ystar <= yy[ihi]) {
                        for (i = 0; i < np; ++i) {
                            pp[ihi][i] = pstar[i];
                        }
                        yy[ihi] = ystar;
                    }
                    for (i = 0; i < np; ++i) {
                        p2star[i] = cCoeff * pp[ihi][i] + (1.0 - cCoeff) * pbar[i];
                    }
                    y2star = this.fcn1(cbs, ctxt, p2star, res);
                    ++nIter;
                    if (y2star > yy[ihi]) {
                        for (j = 0; j < nnp; ++j) {
                            for (i5 = 0; i5 < np; ++i5) {
                                pp[j][i5] = 0.5 * (pp[j][i5] + pp[ilo][i5]);
                                pmin[i5] = pp[j][i5];
                            }
                        }
                        this.fcn1(nnp, cbs, ctxt, pp, yy, res);
                        nIter += nnp;
                    } else {
                        for (i = 0; i < np; ++i) {
                            pp[ihi][i] = p2star[i];
                        }
                        yy[ihi] = y2star;
                    }
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[ihi][i] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            }
            sumnm = 0.0;
            ynewlo = yy[0];
            ilo = 0;
            for (i = 0; i < nnp; ++i) {
                sumnm += yy[i];
                if (!(ynewlo > yy[i])) continue;
                ynewlo = yy[i];
                ilo = i;
            }
            sumnm /= (double)nnp;
            summnm = 0.0;
            for (i = 0; i < nnp; ++i) {
                zn = yy[i] - sumnm;
                summnm += zn * zn;
            }
            curMin = Math.sqrt(summnm / (double)np);
            for (i = 0; i < nnp; ++i) {
                if (yy[i] >= fTol) continue;
                res.status = 1;
                res.termMsg = "Met mean sqr error stopping criterion";
                test = false;
            }
            minimum = ynewlo;
            if (!test) {
                for (i = 0; i < np; ++i) {
                    pmin[i] = pp[ilo][i];
                }
                yy[nnp - 1] = ynewlo;
                simplexSd = curMin;
                if (--jcount > 0) {
                    test = true;
                    for (j = 0; j < np; ++j) {
                        pmin[j] = pmin[j] + step[j];
                        for (i5 = 0; i5 < np; ++i5) {
                            pp[j][i5] = pmin[i5];
                        }
                        pmin[j] = pmin[j] - step[j];
                    }
                    this.fcn1(np, cbs, ctxt, pp, yy, res);
                }
            }
            if (!test || nIter <= nMax) continue;
            convStatus = false;
            for (i = 0; i < np; ++i) {
                pmin[i] = pp[ilo][i];
            }
            yy[nnp - 1] = ynewlo;
            res.status = 1;
            res.termMsg = "Met # calls stopping criterion";
            test = false;
        }
        for (i = 0; i < np; ++i) {
            pmin[i] = pp[ihi][i];
            paramValue[i] = pmin[i];
        }
        minimum = ynewlo;
        kRestart = konvge - jcount;
    }

    public double fcn1(OptimCallbacks cbs, RTContext ctxt, double[] x, OptimResults res) throws Xcept {
        double[] x1 = new double[x.length - 1];
        for (int i = 0; i < x1.length; ++i) {
            x1[i] = x[i];
        }
        double fx = cbs.calcError(ctxt, x1, res);
        return fx;
    }

    public int fcn1(int nc, OptimCallbacks cbs, RTContext ctxt, double[][] x, double[] fx, OptimResults res) throws Xcept {
        int np = x[0].length - 1;
        double[][] x1 = new double[nc][np];
        for (int i = 0; i < nc; ++i) {
            for (int j = 0; j < np; ++j) {
                x1[i][j] = x[i][j];
            }
        }
        double[] fx1 = new double[nc];
        int ret = cbs.calcErrors(ctxt, x1, fx1, res);
        for (int i = 0; i < nc; ++i) {
            fx[i] = fx1[i];
        }
        return ret;
    }

    public double square(double d) {
        return d * d;
    }

    public double truncate(double d, double prec) {
        return d;
    }

    public boolean allowMP() {
        return true;
    }

    public String diagInfo() {
        return "Nelder-Mead optimizer";
    }
}

