/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.data.SensMatrix;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.Xcept;
import Jama.Matrix;

public class Sensop
extends Optimizer {
    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "sensop";
        algInfo.boundsNeeded = true;
        algInfo.sensMatNeeded = true;
        algInfo.parsNeeded = new String[]{"stepTol", "gradTol"};
        algInfo.optimClassName = Sensop.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults res, OptimCallbacks cbs) throws Xcept {
        int ix;
        OptimArgs args = res.args;
        int nx = args.nx();
        double[] xmin = args.xmin;
        double[] xmax = args.xmax;
        if (Util.hasNaNs((double[])xmin) || Util.hasNaNs((double[])xmax)) {
            throw new Xcept((DiagInfo)this, "xmin & xmax required");
        }
        double[] x = args.xstart;
        double[] x0 = (double[])x.clone();
        double[] x1 = (double[])x.clone();
        double stptl = args.stepTol;
        double grdtl = args.gradTol;
        double ssetl = args.errTol;
        int maxfn = args.maxCalls;
        boolean bypassrest = false;
        boolean doagain = true;
        double epslon = 2.38418579E-7;
        double eps1 = 4.882812499E-4;
        double eps2 = 0.004882812499;
        double rmax = 1.70141183E38;
        double gamma = 0.0;
        double stpnew = rmax;
        double sumd0 = rmax;
        double sumd = 0.0;
        double factor = 0.025;
        double st2tl = stptl * stptl;
        double gradtl = rmax;
        double[][] s = null;
        int nd = 1;
        double[] maxSen = null;
        double[] maxSenH = null;
        double[] wgtDev = null;
        int ifn = 0;
        double[] dx = new double[nx];
        double[] delx = new double[nx];
        double[] dxgrad = new double[nx];
        double[] errs = new double[nx + 1];
        int[] inbounds = new int[nx];
        int[] idx = new int[nx];
        double temp = 0.0;
        double[][] wk = new double[nx][nx];
        double[] scale = new double[nx];
        double hnm = 0.0;
        int nxa = nx;
        boolean runagain = true;
        boolean[] recompute = new boolean[nx];
        for (ix = 0; ix < nx; ++ix) {
            dx[ix] = 0.0;
            delx[ix] = Math.abs(eps2 * x[ix]);
            if (delx[ix] != 0.0) continue;
            delx[ix] = eps2;
        }
        while (doagain) {
            int ix2;
            int jxa;
            int ix3;
            int ix4;
            for (ix = 0; ix < nx; ++ix) {
                inbounds[ix] = 0;
                x1[ix] = x0[ix] - gamma * dx[ix];
                if (x1[ix] <= xmin[ix]) {
                    inbounds[ix] = -1;
                    x1[ix] = xmin[ix];
                }
                if (!(x1[ix] >= xmax[ix])) continue;
                inbounds[ix] = 1;
                x1[ix] = xmax[ix];
            }
            sumd = cbs.calcError(ctxt, x1, res);
            bypassrest = false;
            if (++ifn >= maxfn) {
                this.sendMsg(res, 4);
                return;
            }
            if (sumd > sumd0 && (gamma /= 2.0) > eps1) {
                bypassrest = true;
            }
            if (bypassrest) continue;
            if (gamma <= 0.5 && factor <= 200.0) {
                factor *= 2.0;
            }
            if (gamma == 1.0 && factor > eps1) {
                factor *= 0.5;
            }
            if (sumd <= ssetl) {
                this.sendMsg(res, 1);
                return;
            }
            if (gradtl <= grdtl) {
                this.sendMsg(res, 2);
                return;
            }
            if (stpnew <= st2tl) {
                this.sendMsg(res, 3);
                return;
            }
            runagain = true;
            double localfactor = eps1 * 0.1;
            for (int ix5 = 1; ix5 < nx; ++ix5) {
                recompute[ix5] = true;
            }
            int nloop = 0;
            while (runagain && nloop < 3) {
                if (ifn + nx + 1 >= maxfn) {
                    this.sendMsg(res, 5);
                    return;
                }
                ++nloop;
                double smin = 0.0;
                double[] sdx = new double[nx];
                for (int ix6 = 0; ix6 < nx; ++ix6) {
                    sdx[ix6] = this.validdx(x1[ix6], delx[ix6], xmin[ix6], xmax[ix6]);
                    delx[ix6] = Math.abs(sdx[ix6]);
                }
                SensMatrix smat = cbs.calcSensMatrix(ctxt, x1, sdx, errs, res);
                ifn += nx + 1;
                s = smat.getWgtSensMatrix();
                nd = s.length;
                wgtDev = smat.getWgtDev();
                maxSen = smat.getMaxSen();
                maxSenH = smat.getMaxSenH();
                runagain = false;
                for (ix4 = 0; ix4 < nx; ++ix4) {
                    if (!recompute[ix4]) continue;
                    recompute[ix4] = false;
                    smin = eps1 * eps1 / delx[ix4];
                    if (Math.abs(maxSenH[ix4]) > 0.0) {
                        smin *= maxSenH[ix4];
                    }
                    if (!(Math.abs(maxSen[ix4]) < smin)) continue;
                    runagain = true;
                    recompute[ix4] = true;
                    delx[ix4] = Math.sqrt(10.0) * delx[ix4];
                }
            }
            for (ix3 = 0; ix3 < nx; ++ix3) {
                double delxmx = Math.abs(x1[ix3]);
                if (delxmx == 0.0) {
                    delxmx = 1.0;
                }
                double delxmn = localfactor * delxmx;
                if (maxSen[ix3] == 0.0) continue;
                delx[ix3] = Math.max(delxmn, Math.abs(eps1 * maxSenH[ix3] / maxSen[ix3]));
                delx[ix3] = Math.min(delx[ix3], delxmx);
            }
            if (ifn >= maxfn) {
                this.sendMsg(res, 4);
                return;
            }
            for (ix3 = 0; ix3 < nx; ++ix3) {
                for (int jx = 0; jx < nx; ++jx) {
                    temp = 0.0;
                    for (int k = 0; k < s.length; ++k) {
                        temp += s[k][ix3] * s[k][jx];
                    }
                    wk[ix3][jx] = temp;
                }
                double hnorm = 0.0;
                for (int jx = 0; jx < nx; ++jx) {
                    hnorm += Math.abs(wk[ix3][jx]);
                }
                scale[ix3] = 1.0;
                if (hnorm != 0.0) {
                    scale[ix3] = 1.0 / hnorm;
                }
                hnm = Math.max(hnm, hnorm);
            }
            if (hnm != 0.0) {
                hnm = 2.0 / hnm;
            }
            nxa = nx;
            for (ix3 = 0; ix3 < nx; ++ix3) {
                temp = 0.0;
                for (int id = 0; id < s.length; ++id) {
                    temp += s[id][ix3] * wgtDev[id];
                }
                dx[ix3] = temp;
                dxgrad[ix3] = temp * hnm;
                idx[ix3] = ix3;
                if (inbounds[ix3] < 0 && dx[ix3] < 0.0) {
                    inbounds[ix3] = 0;
                }
                if (inbounds[ix3] > 0 && dx[ix3] > 0.0) {
                    inbounds[ix3] = 0;
                }
                if (inbounds[ix3] == 0) continue;
                --nxa;
            }
            if (nxa < 1) {
                this.sendMsg(res, -10);
                return;
            }
            Matrix DX0 = new Matrix(nxa, 1, 0.0);
            Matrix WK = new Matrix(nxa, nxa, 0.0);
            double theta = 0.0;
            for (ix4 = 0; ix4 < nx; ++ix4) {
                theta += dx[ix4] * dx[ix4];
            }
            gradtl = Math.sqrt(theta);
            theta = gradtl * factor;
            int index = 0;
            for (int jx = 0; jx < nx; ++jx) {
                if (inbounds[jx] == 0) {
                    idx[index] = jx;
                    DX0.set(index, 0, dx[jx]);
                    ++index;
                }
                dx[jx] = 0.0;
            }
            for (jxa = 0; jxa < nxa; ++jxa) {
                for (int ixa = 0; ixa < nxa; ++ixa) {
                    if (jxa == ixa) {
                        double[] dArray = wk[idx[ixa]];
                        int n = idx[jxa];
                        dArray[n] = dArray[n] + theta;
                    }
                    double[] dArray = wk[idx[ixa]];
                    int n = idx[jxa];
                    dArray[n] = dArray[n] * scale[idx[jxa]];
                    WK.set(ixa, jxa, wk[idx[ixa]][idx[jxa]]);
                }
            }
            try {
                DX0 = WK.solve(DX0);
                for (jxa = 0; jxa < nxa; ++jxa) {
                    dx[idx[jxa]] = DX0.get(jxa, 0) * scale[idx[jxa]];
                }
            }
            catch (Exception e) {
                for (int ix7 = 0; ix7 < nx; ++ix7) {
                    dx[ix7] = dxgrad[ix7];
                }
            }
            stpnew = 0.0;
            for (ix2 = 0; ix2 < nx; ++ix2) {
                temp = dx[ix2] / Math.max(Math.abs(x0[ix2]), epslon);
                temp *= temp;
                stpnew += temp;
            }
            gamma = 1.0;
            sumd0 = sumd;
            for (ix2 = 0; ix2 < nx; ++ix2) {
                x0[ix2] = x1[ix2];
            }
        }
    }

    public void sendMsg(OptimResults res, int istat) {
        switch (istat) {
            case 1: {
                this.term(res, "mean sqr error");
                break;
            }
            case 2: {
                this.term(res, "gradient");
                break;
            }
            case 3: {
                this.term(res, "parameter step size");
                break;
            }
            case 4: {
                this.term(res, "# calls");
                break;
            }
            case 5: {
                this.term(res, "# calls would have exceeded");
                break;
            }
            case -10: {
                this.termError(res, "Error calculating transpose matrix.");
                break;
            }
            default: {
                this.termError(res, "Unspecified error in Sensop.");
            }
        }
    }

    public double validdx(double x1, double del, double xmin, double xmax) {
        double deltx = del;
        double DFACT = 0.9;
        double ddx = x1 - deltx > xmin ? -deltx : (x1 + deltx < xmax ? deltx : (x1 < (xmin + xmax) / 2.0 ? DFACT * (xmax - x1) : DFACT * (xmin - x1)));
        return ddx;
    }

    private void term(OptimResults res, String crit) {
        res.status = 1;
        res.termMsg = "Met " + crit + " stopping criterion";
    }

    private void termError(OptimResults res, String crit) {
        res.status = 3;
        res.termMsg = crit;
    }

    public String diagInfo() {
        return "Sensop Optimizer";
    }

    public boolean allowMP() {
        return true;
    }
}

