/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.RealNVar;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan1.DEConTool;
import JSim.plan1.DETool;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Xcept;

public class DEConBuilder {
    public static void build(ToolBox box) throws Xcept {
        for (int i = 0; i < box.size(); ++i) {
            if (!(box.tool(i) instanceof DETool)) continue;
            DETool tool = (DETool)box.tool(i);
            RealNVar v = tool.v;
            for (int j = 0; j < ((Var)v).ndim(); ++j) {
                Domain z = ((Var)v).domain(j);
                DEConBuilder.addToolCon(tool, v, z.lhbc());
                DEConBuilder.addToolCon(tool, v, z.rhbc());
                Var vz = tool.v.deriv(z, false);
                if (vz == null) continue;
                DEConBuilder.addToolCon(tool, vz, SubDom.entire());
                DEConBuilder.addToolCon(tool, vz, z.lhbc());
                DEConBuilder.addToolCon(tool, vz, z.rhbc());
            }
        }
    }

    public static void buildEqn(ToolBox box) throws Xcept {
        for (int i = 0; i < box.math.eqn.size(); ++i) {
            Eqn eqn = box.math.eqn.eqn(i);
            if (!eqn.isEqn() || box.tool(eqn) != null) continue;
            Var.List vlist = eqn.varList();
            if (eqn.sdom().isEntire()) {
                DEConBuilder.addStateEqn(box, eqn);
                continue;
            }
            DEConBuilder.addBCEqn(box, eqn);
        }
    }

    private static void addToolCon(DETool detool, Var v, SubDom sdom) throws Xcept {
        ToolBox box = detool.box;
        Tool tool = box.tool(v, sdom);
        if (tool == null) {
            return;
        }
        if (tool == detool) {
            return;
        }
        if (tool.borg.size() > 0) {
            return;
        }
        if (tool instanceof DEConTool) {
            return;
        }
        DEConTool con = new DEConTool(box, detool, tool);
        tool.borg.add(con);
        box.addTool(con);
    }

    private static void addStateEqn(ToolBox box, Eqn eqn) throws Xcept {
        Var.List vlist = eqn.varList();
        Var.List vtally = new Var.List(2);
        Domain.List derivDom = new Domain.List(1);
        for (int i = 0; i < vlist.size(); ++i) {
            Var z = vlist.var(i);
            Var z0 = z.zeroDeriv();
            Tool ztool = box.tool(z, SubDom.entire());
            Tool z0tool = box.tool(z0, SubDom.entire());
            if (z0tool == null) {
                return;
            }
            if (!(z0tool instanceof DETool)) {
                if (ztool != null) continue;
                return;
            }
            vtally.addUniq((Expr)z);
        }
        Var.List vstate = new Var.List(1);
        for (int i = 0; i < vtally.size(); ++i) {
            Var v0 = vtally.var(i).zeroDeriv();
            Domain.List doms = new Domain.List(1);
            for (int j = i; j < vtally.size(); ++j) {
                Var z = vtally.var(j);
                Var z0 = z.zeroDeriv();
                if (z0 != v0 || z == z0) continue;
                doms.addUniq((Expr)z.derivDomain());
            }
            if (doms.size() < 2) continue;
            vstate.addUniq((Expr)v0);
        }
        if (vstate.size() == 0) {
            return;
        }
        if (vstate.size() > 1) {
            throw new Xcept((DiagInfo)eqn, "Multivariate ODE/PDE state eqns not yet supported");
        }
        DEConTool con = new DEConTool(box, vstate, eqn);
        box.useEqn(eqn, con);
        box.addTool(con);
    }

    private static void addBCEqn(ToolBox box, Eqn eqn) throws Xcept {
        Domain x = eqn.sdom().bcDomain();
        Var.List vlist = eqn.varList();
        Var.List vstate = new Var.List(2);
        for (int i = 0; i < vlist.size(); ++i) {
            Var z = vlist.var(i);
            Var z0 = z.zeroDeriv();
            Tool ztool = box.tool(z, SubDom.entire());
            Tool z0tool = box.tool(z0, SubDom.entire());
            if (z0tool == null) {
                return;
            }
            if (!(z0tool instanceof DETool)) {
                if (ztool != null) continue;
                return;
            }
            if (!z.hasDomain(x)) continue;
            vstate.addUniq((Expr)z0);
        }
        DEConTool con = new DEConTool(box, vstate, eqn);
        box.useEqn(eqn, con);
        box.addTool(con);
    }
}

