/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Eqn;
import JSim.mml.Var;
import JSim.plan1.BoundBuilder;
import JSim.plan1.ExprTool;
import JSim.plan1.FzeroTool;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.Algebra;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.NamedExpr;
import JSim.util.Xcept;

public class ExprBuilder {
    protected static void build(ToolBox box) throws Xcept {
        for (int i = 0; i < box.math.eqn.size(); ++i) {
            Eqn eqn = box.math.eqn.eqn(i);
            if (!eqn.isEqn() || box.tool(eqn) != null) continue;
            Var.List vlist = eqn.varList();
            Var v = null;
            int vct = 0;
            for (int j = 0; j < vlist.size(); ++j) {
                Var z = vlist.var(j);
                Tool tool = box.tool(z, eqn.sdom());
                if (tool != null) continue;
                v = z;
                ++vct;
            }
            if (vct > 1) continue;
            if (vct == 0) {
                throw new Xcept((DiagInfo)eqn, "Equation redundant or overspecifies system");
            }
            Tool t = ExprBuilder.varTool(box, v, eqn);
            box.addTool(t);
            box.useEqn(eqn, t);
        }
    }

    public static Tool varTool(ToolBox box, Var v, Eqn eqn) throws Xcept {
        try {
            Expr expr = Algebra.solve((NamedExpr)v, (Expr)eqn.lhs, (Expr)eqn.rhs);
            expr = expr.simplify();
            return new ExprTool(box, v, expr, eqn.sdom());
        }
        catch (Xcept e) {
            FzeroTool t = new FzeroTool(box, eqn.sdom(), v, eqn);
            BoundBuilder.add(t);
            return t;
        }
    }
}

