/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.aserver.ASConstraint;
import JSim.data.NamedVal;
import JSim.mml.Domain;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.Var;
import JSim.plan.BuildControl;
import JSim.plan.Cache;
import JSim.plan.Calc;
import JSim.plan.JSPlanWriter;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.PlanIF;
import JSim.plan.Proc;
import JSim.plan.TopProc;
import JSim.plan1.DEBlockBuilder;
import JSim.plan1.DEBlockTool;
import JSim.plan1.ExprTool;
import JSim.plan1.PlanSeq;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.plan1.ToolSet;
import JSim.plan1.XMMLOutput;
import JSim.util.DiagInfo;
import JSim.util.EntireSet;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.TypedSet;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.XFunc;
import JSim.util.Xcept;
import org.w3c.dom.Document;

public class Plan
implements PlanIF {
    public Model model;
    public MathSys math;
    public BuildControl buildControl;
    public Var.List inputVars;
    public Expr.List inputDefs;
    public TopProc mainProc;
    public Proc.List procs;
    public Cache cache;
    public Unit.List units;
    public XFunc.NList funcs;
    public Expr.List funcCalls;
    private int[] varPhases;
    private int maxPhase;
    protected ToolBox box;
    protected ToolSet toolSeq;
    protected PlanSeq seq;
    protected Tool.List toolRem;

    public Plan(Model m) throws Xcept {
        this(m, new BuildControl.Tester());
    }

    public Plan(Model m, BuildControl bc) throws Xcept {
        int i;
        this.buildControl = bc;
        this.model = m.getFlatModel();
        this.math = m.getFlatMath();
        Util.verbose((String)"==== TALLYING REQUIRED UNITS");
        this.units = new Unit.List(8);
        this.math.addSubUnits(this.units, this.model.units);
        for (int i2 = 0; i2 < this.units.size(); ++i2) {
            Unit u = this.units.unit(i2);
            Util.verbose((String)("\t" + u.name() + " " + u));
        }
        this.box = new ToolBox(this.math, this.buildControl);
        this.box.validate();
        Util.verbose((String)"==== UNBORGED TOOLS");
        this.unborgedTools();
        DEBlockBuilder blocks = new DEBlockBuilder(this.box);
        Util.verbose((String)"==== ADDING AUXTOOL ICs");
        for (int i3 = 0; i3 < this.box.domains.size(); ++i3) {
            Domain t = this.box.domains.domain(i3);
            ToolSet set = new ToolSet(this.box);
            for (int j = 0; j < this.box.size(); ++j) {
                if (!(this.box.tool(j) instanceof DEBlockTool)) continue;
                DEBlockTool block = (DEBlockTool)this.box.tool(j);
                if (block.t != t) continue;
                set.add(block.auxTools());
            }
            Tool.List list = set.toolList();
            for (int j = 0; j < list.size(); ++j) {
                Tool otool = list.tool(j);
                Tool ntool = otool.iccopy(t);
                if (ntool == null) continue;
                this.box.addTool(ntool);
            }
        }
        Util.verbose((String)"==== SEQUENCABLE TOOLS");
        this.toolSeq = this.unborgedTools();
        Util.verbose((String)"==== ISOLATING INPUT VARIABLES");
        this.inputVars = new Var.List(1);
        this.inputDefs = new Expr.List(1);
        Known known = this.math.createKnown();
        ToolSet toolInput = new ToolSet(this.box);
        for (int i4 = 0; i4 < this.box.size(); ++i4) {
            Var v;
            Tool tool = this.box.tool(i4);
            if (!this.toolSeq.hasTool(tool) || !tool.isInputTool() || (v = tool.vsol.var(0)).isState()) continue;
            Expr vdef = tool instanceof ExprTool ? ((ExprTool)tool).expr() : null;
            this.inputVars.add((Object)v);
            this.inputDefs.add((Object)vdef);
            known.root().setSet((NamedExpr)v, Expr.entire);
            toolInput.add(tool);
            Util.verbose((String)("\t" + tool));
        }
        Util.verbose((String)"==== MAINLINE CALCULATIONS");
        this.toolSeq.sub(toolInput);
        Tool.List mtools = this.toolSeq.toolList();
        this.mainProc = new TopProc(this, "mainline");
        this.seq = new PlanSeq(this, known, mtools);
        this.seq.buildDeep();
        this.seq.append(this.mainProc.mcalc);
        Util.verbose((String)"==== ASSIGN VAR PHASES");
        this.varPhases = new int[this.math.nVar()];
        for (int i5 = 0; i5 < this.inputVars.size(); ++i5) {
            int j = this.inputVars.var(i5).flatInx();
            this.varPhases[j] = 1;
        }
        int phase = 2;
        MultiCalc mcalc = this.mainProc.mcalc;
        for (int i6 = 0; i6 < mcalc.size(); ++i6) {
            Calc calc = mcalc.calc(i6);
            boolean newPhase = calc instanceof LoopCalc;
            if (i6 > 0 && mcalc.calc(i6 - 1) instanceof LoopCalc) {
                newPhase = true;
            }
            if (newPhase) {
                ++phase;
                if (calc instanceof LoopCalc) {
                    ((LoopCalc)calc).phase = phase;
                }
            }
            Var.List vars = new Var.List(4);
            calc.addVars(vars);
            for (int j = 0; j < vars.size(); ++j) {
                Var v = vars.var(j);
                int k = v.flatInx();
                if (calc.recalc()) continue;
                this.varPhases[k] = phase;
            }
        }
        this.maxPhase = phase;
        boolean phaseError = false;
        for (int i7 = 0; i7 < this.math.nVar(); ++i7) {
            Var v = this.math.var(i7);
            if (v.isPrivate()) continue;
            boolean verr = false;
            if (this.phase(v) <= 0) {
                verr = true;
            }
            if (this.inputVars.contains((Object)v)) {
                if (this.phase(v) != 1) {
                    verr = true;
                }
            } else if (this.phase(v) == 1) {
                verr = true;
            }
            Util.verbose((String)("    Var " + (Object)((Object)v) + ": phase=" + this.phase(v) + (verr ? " error" : "")));
            phaseError = phaseError || verr;
        }
        if (phaseError) {
            throw new Xcept((DiagInfo)this.math, "Variable phase assignment planning error");
        }
        this.procs = new Proc.List(4);
        this.mainProc.addProcList(this.procs);
        Util.verbose((String)"==== CHECKING FOR UNSOLVED VARIABLES");
        boolean ok = true;
        for (int i8 = 0; i8 < this.math.nVar(); ++i8) {
            Var v = this.math.var(i8);
            if (v.isPrivate()) continue;
            TypedSet vset = this.seq.known.getSet((NamedExpr)v);
            boolean vsolved = vset instanceof EntireSet;
            Util.verbose((String)("\t" + (Object)((Object)v) + (vsolved ? " solved" : " unsolved")));
            if (vsolved) continue;
            ok = false;
        }
        if (!ok) {
            if (Util.verbose) {
                Util.verbose((String)"==== INCOMPLETE PLAN DUMP");
                JSPlanWriter pwrt = new JSPlanWriter(this);
                pwrt.write(System.err);
            }
            throw new Xcept("Not all public variables were solved");
        }
        Util.verbose((String)"\tAll variables solved.");
        Cache icache = new Cache();
        for (i = 0; i < this.math.nVar(); ++i) {
            Var v = this.math.var(i);
            boolean add = false;
            if (v.ndim() == 0 && this.inputVars.contains((Object)v)) {
                add = true;
            } else if (v.isState()) {
                add = true;
            }
            if (!add) continue;
            icache.v0.add((Object)v);
        }
        Util.verbose((String)"==== Finalizing calculation tree");
        this.mainProc.setParents(null, null);
        Util.verbose((String)"==== Propagating variable caches");
        this.mainProc.propagateCache(icache);
        this.cache = new Cache();
        this.cache.add(this.mainProc.cache);
        for (i = 0; i < this.procs.size(); ++i) {
            Proc p = this.procs.proc(i);
            this.cache.add(p.cache);
        }
        Util.verbose((String)("\tCombined cache = " + this.cache));
        Util.verbose((String)"==== Pretty proc names");
        for (i = 0; i < this.procs.size(); ++i) {
            this.procs.proc((int)i).name = "Step_" + (i + 1);
        }
        Util.verbose((String)"==== Required functions");
        this.funcs = this.model.neededFuncs();
        this.funcCalls = this.model.funcCalls();
        for (i = 0; i < this.funcs.size(); ++i) {
            Util.verbose((String)("\t" + this.funcs.xfunc(i).diagInfo()));
        }
    }

    public ToolSet unborgedTools() throws Xcept {
        ToolSet set = new ToolSet(this.box);
        for (int i = 0; i < this.box.size(); ++i) {
            Tool tool = this.box.tool(i);
            if (tool.borg.size() > 0) continue;
            Util.verbose((String)("\t" + tool + " solving " + (Object)((Object)tool.vsol) + " requiring " + (Object)((Object)tool.vreq)));
            set.add(tool);
        }
        return set;
    }

    public int phase(NamedExpr n) {
        if (n instanceof Var) {
            Var v = (Var)n;
            int i = v.flatInx();
            return this.varPhases[i];
        }
        return -1;
    }

    public Document getXMML() throws Xcept {
        XMMLOutput out = new XMMLOutput(this);
        return out.getDocument();
    }

    public int maxPhase() {
        return this.maxPhase;
    }

    public Model model() {
        return this.model;
    }

    public MathSys math() {
        return this.math;
    }

    public Var.List inputVars() {
        return this.inputVars;
    }

    public Expr inputDef(Var v) throws Xcept {
        int inx = this.inputVars.indexOf((Object)v);
        return this.inputDefs.expr(inx);
    }

    public ToolBox box() {
        return this.box;
    }

    public Cache cache() {
        return this.cache;
    }

    public TopProc mainProc() {
        return this.mainProc;
    }

    public Proc.List procs() {
        return this.procs;
    }

    public Unit.List units() {
        return this.units;
    }

    public XFunc.NList funcs() {
        return this.funcs;
    }

    public Expr.List funcCalls() {
        return this.funcCalls;
    }

    public void addProperties(NamedVal.NList props) throws Xcept {
        this.box.addProperties(props);
    }

    public ASConstraint.Info[] getConstraints() throws Xcept {
        return this.box.getConstraints();
    }
}

