/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.aserver.ASConstraint;
import JSim.data.NamedVal;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.MathSys;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan.BuildControl;
import JSim.plan1.DEBlockTool;
import JSim.plan1.DEBuilder;
import JSim.plan1.DEConBuilder;
import JSim.plan1.DETool;
import JSim.plan1.DerivBuilder;
import JSim.plan1.DomainBuilder;
import JSim.plan1.EventBuilder;
import JSim.plan1.ExprBuilder;
import JSim.plan1.ExprTool;
import JSim.plan1.ExternBuilder;
import JSim.plan1.FuncBuilder;
import JSim.plan1.FuncTool;
import JSim.plan1.FzeroBuilder;
import JSim.plan1.RelationBuilder;
import JSim.plan1.Tool;
import JSim.util.ConstExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintStream;

public class ToolBox {
    protected MathSys math;
    protected Domain.List domains;
    protected Tool.List box;
    private Tool[] entireTool;
    private Tool[] eqnTool;
    private int updatect;
    private BuildControl buildControl;
    private EventBuilder eventBldr;

    public ToolBox(MathSys mm) throws Xcept {
        this(mm, new BuildControl.Tester());
    }

    public ToolBox(MathSys mm, BuildControl bc) throws Xcept {
        this.buildControl = bc;
        Util.verbose((String)"==== BUILDING TOOLBOX");
        this.math = mm;
        if (!this.math.isFlat()) {
            throw new Xcept((DiagInfo)this.math, "Flat MathSys required for toolbox creation");
        }
        this.domains = new Domain.List(1);
        for (int i = 0; i < this.math.nVar(); ++i) {
            if (!this.math.var(i).isDomain()) continue;
            this.domains.add((Object)this.math.var(i));
        }
        this.box = new Tool.List(this.math.nVar());
        this.entireTool = new Tool[this.math.nVar()];
        this.eqnTool = new Tool[this.math.eqn.size() + 1];
        this.updatect = 0;
        this.eventBldr = new EventBuilder(this);
        FzeroBuilder fzerobldr = new FzeroBuilder(this);
        ExternBuilder.build(this);
        FuncBuilder.build(this);
        RelationBuilder.build(this);
        int lastct = this.updatect() - 1;
        while (this.updatect() > lastct) {
            Util.verbose((String)"    ==ToolBuilder loop");
            this.checkCancel();
            lastct = this.updatect();
            ExprBuilder.build(this);
            DomainBuilder.build(this);
            DerivBuilder.build(this);
            this.eventBldr.build();
            DEBuilder.build(this);
            DEConBuilder.build(this);
            if (lastct == this.updatect()) {
                DEConBuilder.buildEqn(this);
            }
            if (lastct != this.updatect()) continue;
            fzerobldr.build();
        }
    }

    public void validate() throws Xcept {
        Tool t;
        int i;
        Util.verbose((String)"    ==ToolBuilder validate");
        this.eventBldr.validate();
        for (i = 0; i < this.math.eqn.size(); ++i) {
            Eqn eqn = this.math.eqn.eqn(i);
            if (this.tool(eqn) != null) continue;
            Var.List vars1 = eqn.varList();
            Var.List vars2 = new Var.List(vars1.size());
            for (int j = 0; j < vars1.size(); ++j) {
                Var v = vars1.var(j).zeroDeriv();
                if (this.tool(v, SubDom.entire()) != null) continue;
                vars2.addUniq((Expr)v);
            }
            throw new Xcept((DiagInfo)eqn, "Equation cannot be processed. Check defining equations (perhaps IC/BCs) for variable" + (vars2.size() == 1 ? " " : "s ") + (Object)((Object)vars2) + ".");
        }
        for (i = 0; i < this.size(); ++i) {
            t = this.tool(i);
            if (t.isRelation() || t.sdsol.isEntire() || t.borg.size() != 0 || t instanceof FuncTool) continue;
            throw new Xcept((DiagInfo)t, "Equation unneccessary and overspecifies system(2)");
        }
        for (i = 0; i < this.size(); ++i) {
            Var v0;
            if (!(this.tool(i) instanceof ExprTool)) continue;
            t = (ExprTool)this.tool(i);
            if (((ExprTool)t).borg.size() != 0 || ((ExprTool)t).v.nDeriv() == 0 || !((ExprTool)t).vreq.contains((Object)(v0 = ((ExprTool)t).v.zeroDeriv()))) continue;
            throw new Xcept((DiagInfo)t, "Equation unneccessary and overspecifies system(3)");
        }
        for (i = 0; i < this.size(); ++i) {
            t = this.tool(i);
            t.validate();
        }
        for (i = 0; i < this.math.nVar(); ++i) {
            Tool tool;
            Var v = this.math.var(i);
            if (this.tool(v, SubDom.entire()) != null || v.nDeriv() > 0 && (tool = this.tool(v.zeroDeriv(), SubDom.entire())) instanceof DETool) continue;
            throw new Xcept((DiagInfo)v, "Cannot entirely solve this variable");
        }
    }

    protected void addTool(Tool t) throws Xcept {
        Util.verbose((String)("\tBox.add[" + this.box.size() + "]: " + t + " solving " + (Object)((Object)t.vsol) + " requiring " + (Object)((Object)t.vreq)));
        t.inx = this.box.size();
        this.box.add(t);
        ++this.updatect;
        if (!t.sdsol.isEntire()) {
            return;
        }
        for (int i = 0; i < t.vsol.size(); ++i) {
            Tool et;
            Var v = (Var)t.vsol.comp(i);
            int inx = v.flatInx();
            if (inx >= this.entireTool.length) {
                Tool[] net = new Tool[inx + 1];
                for (int j = 0; j < this.entireTool.length; ++j) {
                    net[j] = this.entireTool[j];
                }
                this.entireTool = net;
            }
            if ((et = this.entireTool[inx]) != null && et.borg.size() == 0) {
                if (t instanceof DEBlockTool && et instanceof DEBlockTool) {
                    Util.verbose((String)("\t    " + (Object)((Object)v) + " reblocked muCompatible variable"));
                    continue;
                }
                throw new Xcept((DiagInfo)v, "Variable is overspecified");
            }
            this.entireTool[inx] = t;
        }
    }

    protected void update(Tool t) {
        ++this.updatect;
    }

    public int updatect() {
        return this.updatect;
    }

    protected void useEqn(Eqn eqn, Tool t) throws Xcept {
        this.eqnTool[eqn.flatInx()] = t;
    }

    public Tool tool(Eqn eqn) throws Xcept {
        return this.eqnTool[eqn.flatInx()];
    }

    public Tool tool(Var v, SubDom sd) throws Xcept {
        Tool t;
        int inx = v.flatInx();
        Tool tool = t = inx < this.entireTool.length ? this.entireTool[inx] : null;
        if (t != null) {
            if (sd.isEntire()) {
                return t;
            }
            if ((t = t.sdTool(sd)) != null) {
                return t;
            }
        }
        for (int i = 0; i < this.box.size(); ++i) {
            t = this.box.tool(i);
            if (!t.solves(v, sd)) continue;
            return t;
        }
        return null;
    }

    public int size() {
        return this.box.size();
    }

    public Tool tool(int i) {
        return this.box.tool(i);
    }

    public String toString() {
        return this.box.toString();
    }

    protected void checkCancel() throws Xcept {
        String s = this.buildControl.buildCancelMessage();
        if (s == null) {
            return;
        }
        Var.List vars = this.likelyVars();
        throw new Xcept((DiagInfo)this.math, "Model build canceled by " + s + ". Long compile likely caused by missing " + "equations (perhaps IC/BCs) for variable" + (vars.size() == 1 ? " " : "s ") + (Object)((Object)vars) + ".");
    }

    public Var.List likelyVars() throws Xcept {
        Var.List vars = new Var.List(4);
        for (int i = 0; i < this.math.nVar(); ++i) {
            Var v = this.math.var(i);
            if (v.nDeriv() > 0 || this.tool(v, SubDom.entire()) != null) continue;
            boolean lhs = false;
            for (int j = 0; j < this.math.eqn.size(); ++j) {
                Eqn eqn = this.math.eqn.eqn(j);
                if (!v.sameAs(eqn.lhs)) continue;
                lhs = true;
                break;
            }
            if (lhs) continue;
            vars.add((Object)v);
        }
        return vars;
    }

    public Expr simplify(Expr expr) throws Xcept {
        Expr.List list = new Expr.List(16);
        expr.addNamedExpr(list);
        Expr.List vars = new Expr.List(16);
        Expr.List vals = new Expr.List(16);
        for (int i = 0; i < list.size(); ++i) {
            Var v;
            ConstExpr val;
            if (!(list.expr(i) instanceof Var) || (val = this.fixedVal(v = (Var)list.expr(i))) == null) continue;
            vars.add((Object)v);
            vals.add((Object)val);
        }
        if (vars.size() > 0) {
            Expr expr1 = expr.replace(vars, vals);
            expr = expr1.simplify();
        }
        if (expr instanceof ConstExpr) {
            return (ConstExpr)expr;
        }
        if (expr.isConst()) {
            return expr.cons();
        }
        return expr;
    }

    private ConstExpr fixedVal(Var v) throws Xcept {
        Tool tool = this.tool(v, SubDom.entire());
        if (!(tool instanceof ExprTool)) {
            return null;
        }
        boolean fixable = false;
        if (v.isPrivate()) {
            fixable = true;
        }
        if (v.nDeriv() > 0 && v.zeroDeriv().isState()) {
            fixable = true;
        }
        if (!fixable) {
            return null;
        }
        Expr expr = ((ExprTool)tool).expr();
        if ((expr = this.simplify(expr)).isConst()) {
            return expr.cons();
        }
        return null;
    }

    public void dump(PrintStream out) throws Xcept {
        int i;
        out.println("====== ALL TOOLS ========");
        for (i = 0; i < this.box.size(); ++i) {
            Tool t = this.box.tool(i);
            out.println("\t" + t + " :: solves=" + (Object)((Object)t.vsol) + " reqs=" + (Object)((Object)t.vreq));
        }
        out.println("====== ENTIRE TOOLS by VAR ========");
        for (i = 0; i < this.math.nVar(); ++i) {
            Var v = this.math.var(i);
            Tool t = this.tool(v, SubDom.entire());
            out.println("\t" + (Object)((Object)v) + " :: " + (t == null ? "NONE" : t.toString()));
        }
        out.println("======= EQNs in some TOOL? ========");
        for (i = 0; i < this.math.eqn.size(); ++i) {
            Eqn eqn = this.math.eqn.eqn(i);
            out.println("\t" + eqn + " :: " + (this.tool(eqn) != null));
        }
    }

    public ASConstraint.Info[] getConstraints() throws Xcept {
        ASConstraint.Info[] infos = this.math.getConstraints();
        for (int i = 0; i < this.math.eqn.size(); ++i) {
            Eqn eqn = this.math.eqn.eqn(i);
            Tool tool = this.tool(eqn);
            if (tool == null || tool.vsol().size() <= 0) continue;
            infos[i].vout = tool.vsol().stringList().array();
        }
        return infos;
    }

    private void loadInfo(Tool tool, ASConstraint.Info info) throws Xcept {
        if (tool == null) {
            return;
        }
        if (tool.vsol().size() > 0) {
            info.vout = tool.vsol().stringList().array();
        }
        if (!tool.sdsol.isEntire()) {
            info.vout_sdom = tool.sdsol.expr.toString();
        }
    }

    public void addProperties(NamedVal.NList props) throws Xcept {
        for (int i = 0; i < this.math.nVar(); ++i) {
            String info;
            Var v = this.math.var(i);
            Tool tool = this.tool(v, SubDom.entire());
            if (tool == null || (info = tool.calcInfo(v)) == null) continue;
            NamedVal prop = NamedVal.create((String)(v.toString() + ".calc"), (String)info);
            props.add((Named)prop);
        }
    }
}

