/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml;

import JSim.mathml.MLLambda;
import JSim.mathml.MLMath;
import JSim.sbml.SBModel;
import JSim.sbml.SBVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.NamedRealConst;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.List;
import jigcell.sbml2.FunctionDefinition;

public class SBFunction
implements Named {
    protected SBModel sbmodel;
    protected FunctionDefinition func;
    protected String name;
    protected MLLambda lambda;
    protected int ncalls;

    public SBFunction(SBModel sm, FunctionDefinition c) throws Xcept {
        this.sbmodel = sm;
        this.func = c;
        this.name = this.func.getId();
        String text = this.func.getMath().replaceAll("math:", "");
        MLMath math = new MLMath(text);
        this.lambda = math.makeLambda(this.sbmodel, this.sbmodel.csymbols);
        this.ncalls = 0;
    }

    protected Expr makeCall(Expr.List args) throws Xcept {
        if (this.lambda.nargs() != args.size()) {
            throw new Xcept((DiagInfo)this, "Function requires " + this.lambda.nargs() + " arguments, " + args.size() + " were found.");
        }
        String vname = this.name + ".call" + this.ncalls++;
        SBVar v = new SBVar(this.sbmodel, vname, "functionCall");
        v.setPrivate(true);
        Expr expr = this.lambda.eval();
        expr = expr.replace(this.lambda.args(), args);
        String vassn = expr.toString((Context)this.sbmodel.ctxt);
        v.setAssign(vassn);
        return new NamedRealConst(vname, 0.0);
    }

    public String name() {
        return this.name;
    }

    public String diagInfo() {
        return "Function definition " + this.name + this.lambda.args() + "=" + this.lambda.eval();
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("  // " + this.diagInfo() + ";");
    }

    public static class NList
    extends NamedList {
        public NList() {
        }

        public NList(SBModel sbm) throws Xcept {
            this.load(sbm);
        }

        public void load(SBModel sbm) throws Xcept {
            List list = sbm.model.getFunctionDefinitions();
            for (int i = 0; i < list.size(); ++i) {
                this.add(new SBFunction(sbm, (FunctionDefinition)list.get(i)));
            }
        }

        public SBFunction sbfunc(int i) {
            return (SBFunction)this.get(i);
        }

        public SBFunction sbfunc(String n) {
            return (SBFunction)this.getByName(n);
        }
    }
}

