/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml;

import JSim.sbml.SBModel;
import JSim.sbml.SBSpecies;
import JSim.sbml.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import jigcell.sbml2.KineticLaw;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.SimpleSpeciesReference;
import jigcell.sbml2.SpeciesReference;

public class SBReaction
implements Named {
    protected SBModel sbmodel;
    protected Reaction reac;
    protected SBVar vrate;
    protected String eqn;
    public int nstoichs;
    protected ArrayList<Stoich> stoichs;

    public SBReaction(SBModel sm, Reaction c) throws Xcept {
        this.sbmodel = sm;
        this.reac = c;
        this.stoichs = new ArrayList();
        this.addStoich(this.reac.getReactant(), false);
        this.addStoich(this.reac.getProduct(), true);
        this.nstoichs = this.stoichs.size();
        this.eqn = "";
        String eq = this.reac.isReversible() ? "=>" : "<=>";
        for (int i = 0; i < this.nstoichs; ++i) {
            if (eq != null && this.isProduct(i)) {
                this.eqn = this.eqn + eq + " ";
                eq = null;
            }
            if (!this.mult(i).equals("1")) {
                this.eqn = this.eqn + this.mult(i);
            }
            this.eqn = this.eqn + this.spec(i) + " ";
        }
        this.vrate = new SBVar(this.sbmodel, this.name() + ".rate", "rate");
        this.vrate.setConst(false);
        KineticLaw law = this.reac.getKineticLaw();
        String rate = law == null ? this.makeKRate() : this.makeMathRate(law);
        this.vrate.setAssign(rate);
        this.vrate.setUnit("substance/time");
        for (int i = 0; i < this.nstoichs; ++i) {
            String mult = this.mult(i);
            if (!this.isProduct(i)) {
                mult = "-" + mult;
            }
            mult = mult.equals("1") ? "" : mult + "*";
            String delta = mult + this.vrate.mmlName;
            this.vamt(i).addODEDelta(delta);
        }
    }

    private void addStoich(List list, boolean isProduct) throws Xcept {
        for (int i = 0; i < list.size(); ++i) {
            SimpleSpeciesReference sref = (SimpleSpeciesReference)list.get(i);
            String spec = sref.getSpecies();
            SBSpecies sbspec = this.sbmodel.sbspecs.sbspec(spec);
            if (sbspec == null) {
                throw new Xcept("Reaction " + this.name() + ": invalid species " + spec);
            }
            String mult = "1";
            if (sref instanceof SpeciesReference) {
                SpeciesReference ref = (SpeciesReference)sref;
                double stoich = ref.getStoichiometry();
                if (Double.isNaN(stoich)) {
                    String math = ref.getStoichiometryMath().getMath();
                    mult = "(" + this.sbmodel.mathExprMML(math) + ")";
                } else {
                    mult = Util.pretty((double)stoich);
                }
            }
            Stoich stoich = new Stoich();
            stoich.vamt = sbspec.vamt;
            stoich.spec = spec;
            stoich.mult = mult;
            stoich.isProduct = isProduct;
            this.stoichs.add(stoich);
        }
    }

    private String makeMathRate(KineticLaw law) throws Xcept {
        this.sbmodel.sbparms.addList(this.sbmodel, law.getParameter());
        return this.sbmodel.mathExprMML(law.getMath());
    }

    private String makeKRate() throws Xcept {
        SBVar kf = new SBVar(this.sbmodel, this.name() + ".kf", "rate");
        kf.setConst(true);
        kf.setExtern();
        SBVar kb = new SBVar(this.sbmodel, this.name() + ".kb", "rate");
        kb.setConst(true);
        kb.setExtern();
        String krate = "" + kf;
        String kprod = " - " + kb;
        for (int i = 0; i < this.nstoichs; ++i) {
            if (kprod != null && this.isProduct(i)) {
                krate = krate + kprod;
                kprod = null;
            }
            krate = krate + "*" + this.vamt(i);
            if (this.mult(i).equals("1")) continue;
            krate = krate + "^" + this.mult(i);
        }
        return krate;
    }

    public String name() {
        return this.reac.getId();
    }

    public String diagInfo() {
        return "Reaction " + this.name();
    }

    public Stoich stoich(int i) {
        return this.stoichs.get(i);
    }

    public SBVar vamt(int i) {
        return this.stoich((int)i).vamt;
    }

    public String spec(int i) {
        return this.stoich((int)i).spec;
    }

    public String mult(int i) {
        return this.stoich((int)i).mult;
    }

    public boolean isProduct(int i) {
        return this.stoich((int)i).isProduct;
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("// " + this.name() + ": " + this.eqn);
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            List list = sbm.model.getReactions();
            for (int i = 0; i < list.size(); ++i) {
                this.add(new SBReaction(sbm, (Reaction)list.get(i)));
            }
        }

        public NList() {
        }

        public SBReaction sbreac(int i) {
            return (SBReaction)this.get(i);
        }

        public SBReaction sbreac(String n) {
            return (SBReaction)this.getByName(n);
        }
    }

    public static class Stoich {
        public SBVar vamt;
        public String spec;
        public String mult;
        public boolean isProduct;
    }
}

