/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml;

import JSim.sbml.SBModel;
import JSim.sbml.SBVar;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.List;
import jigcell.sbml2.AlgebraicRule;
import jigcell.sbml2.AssignmentRule;
import jigcell.sbml2.RateRule;
import jigcell.sbml2.Rule;
import jigcell.sbml2.VariableRule;

public class SBRule
implements Named {
    protected SBModel sbmodel;
    protected Rule rule;
    protected String aexpr;

    public SBRule(SBModel sm, Rule r) throws Xcept {
        this.sbmodel = sm;
        this.rule = r;
        String text = this.rule.getMath();
        String rhs = this.sbmodel.mathExprMML(text);
        if (this.rule instanceof AssignmentRule) {
            VariableRule vrule = (VariableRule)this.rule;
            SBVar v = this.sbmodel.sbvars.sbvar(vrule.getVariable());
            v.setAssign(rhs);
        } else if (this.rule instanceof AlgebraicRule) {
            this.aexpr = rhs;
        } else if (this.rule instanceof RateRule) {
            VariableRule vrule = (VariableRule)this.rule;
            SBVar v = this.sbmodel.sbvars.sbvar(vrule.getVariable());
            v.setODE(rhs);
        }
    }

    public String name() {
        return "" + this.hashCode();
    }

    public String diagInfo() {
        return "Rule " + this.name();
    }

    public void writeMML(PrintWriter wrt) {
        if (this.aexpr == null) {
            return;
        }
        wrt.println("  " + this.aexpr + " = 0;");
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            List list = sbm.model.getRules();
            for (int i = 0; i < list.size(); ++i) {
                this.add(new SBRule(sbm, (Rule)list.get(i)));
            }
        }

        public NList() {
        }

        public SBRule sbrule(int i) {
            return (SBRule)this.get(i);
        }

        public SBRule sbrule(String n) {
            return (SBRule)this.getByName(n);
        }
    }
}

