/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml;

import JSim.sbml.SBModel;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.List;
import jigcell.sbml2.Unit;
import jigcell.sbml2.UnitDefinition;

public class SBUnit
implements Named {
    protected SBModel sbmodel;
    protected UnitDefinition unit;

    public SBUnit(SBModel sm, UnitDefinition c) throws Xcept {
        this.sbmodel = sm;
        this.unit = c;
        this.declString();
    }

    public String name() {
        return this.unit.getId();
    }

    public String diagInfo() {
        return "UnitDefinition " + this.name();
    }

    public void writeMML(PrintWriter wrt) {
        wrt.println("unit " + this.name() + " = " + this.declString() + ";");
    }

    public String declString() {
        double mult = 1.0;
        String decl = null;
        List list = this.unit.getUnits();
        for (int i = 0; i < list.size(); ++i) {
            Unit u = (Unit)list.get(i);
            mult *= u.getMultiplier() * Math.pow(10.0, u.getScale());
            String s = u.getKindName();
            if (u.getExponent() != 1) {
                s = s + "^" + u.getExponent();
            }
            decl = decl == null ? s : decl + "*" + s;
        }
        if (decl == null) {
            decl = "scalar";
        }
        return Util.pretty((double)mult) + " " + decl;
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            List list = sbm.model.getUnitDefinitions();
            for (int i = 0; i < list.size(); ++i) {
                this.add(new SBUnit(sbm, (UnitDefinition)list.get(i)));
            }
        }

        public NList() {
        }

        public SBUnit sbunit(int i) {
            return (SBUnit)this.get(i);
        }

        public SBUnit sbunit(String n) {
            return (SBUnit)this.getByName(n);
        }
    }
}

