/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.xsim.CF;
import JSim.xsim.CFItem;
import JSim.xsim.CFPar;

public class CFIvar
extends CFItem {
    private String xsname;
    private String jsname;
    public int loc;
    public CFPar pcurr;
    public CFPar pstart;
    public CFPar pstop;
    public CFPar pincr;

    public CFIvar(CF c, String n) {
        super(c);
        this.cf.ivar = this;
        this.xsname = n;
        this.pcurr = new CFPar(this.cf, 4, this.xsname);
        this.pstart = new CFPar(this.cf, 4, this.xsname + "_start");
        this.pstop = new CFPar(this.cf, 4, this.xsname + "_stop");
        this.pincr = new CFPar(this.cf, 4, this.xsname + "_incr");
        this.pincr.skip = true;
        this.pstop.skip = true;
        this.pstart.skip = true;
        this.pcurr.skip = true;
    }

    public void set(String key, String value) {
        if ((key = key.toLowerCase()).equals("loc")) {
            this.loc = this.toInt(value);
            this.pstart.set(key, "" + (this.loc - 2));
            this.pstop.set(key, "" + (this.loc - 1));
            this.pincr.set(key, "" + (this.loc + 1));
        }
    }

    public String name() {
        return this.pcurr.name();
    }

    public void writeMMLVar() {
        this.println("\tivar " + this.name() + "; " + this.name() + ".loc=" + this.loc + ";");
        this.println("\t" + this.eqn(this.pstart) + " " + this.eqn(this.pstop) + " " + this.eqn(this.pincr));
    }

    private String eqn(CFPar p) {
        return p.name() + " = " + p.init + ";";
    }
}

