/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.util.NameSpace;
import JSim.util.NullOutputStream;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;
import JSim.xsim.CF;
import JSim.xsim.CFItem;
import java.io.OutputStream;
import java.io.PrintStream;

public class CFPar
extends CFItem {
    public static final int LOGICAL = 1;
    public static final int CHOICE = 2;
    public static final int INT = 3;
    public static final int REAL = 4;
    public static final int STRING = 5;
    public static final int UNDECIDED = 0;
    public static final int STATIC = 1;
    public static final int DYNAMIC = 2;
    public int type;
    private String xsname;
    private String jsname;
    public int loc;
    public boolean input;
    public int dynamic;
    public int dim1;
    public String init;
    public String fixeval;
    public String eval;
    public String unit;
    public StringList labels;
    public StringList help;
    public int labelBase;
    public boolean skip;
    public PrintStream nullErr;
    public PrintStream saveErr;

    public CFPar(CF c, int t, String n) {
        super(c);
        this.type = t;
        this.xsname = n;
        this.dim1 = 1;
        this.input = true;
        this.dynamic = 0;
        this.labels = new StringList(4);
        n = CFPar.safeName(this.xsname);
        if (!this.xsname.equals(n)) {
            this.rename(n);
        }
        this.help = new StringList(4);
        this.nullErr = new PrintStream((OutputStream)new NullOutputStream());
        this.saveErr = System.err;
    }

    public void rename(String n) {
        this.warn(this.name() + " renamed " + n);
        this.jsname = n;
        this.cf.renamedPars.add(this);
    }

    public void set(String key, String value) {
        if ((key = key.toLowerCase()).equals("input")) {
            this.input = true;
        } else if (key.equals("output")) {
            this.input = false;
        } else if (key.equals("loc")) {
            if (this.type == 4) {
                this.loc = this.toInt(value);
            }
            if (this.loc + this.dim1 > this.cf.maxloc) {
                this.cf.maxloc = this.loc + this.dim1;
            }
        } else if (key.equals("static")) {
            this.dynamic = 1;
        } else if (key.equals("dynamic")) {
            this.dynamic = 2;
        } else if (key.equals("dim1")) {
            this.dim1 = this.toInt(value);
            if (this.loc + this.dim1 > this.cf.maxloc) {
                this.cf.maxloc = this.loc + this.dim1;
            }
            this.cf.dims.addUniq("" + this.dim1);
        } else if (key.equals("init")) {
            this.init = value;
        } else if (key.equals("fixeval")) {
            this.fixeval = value;
        } else if (key.equals("eval")) {
            this.eval = value;
        } else if (key.equals("units")) {
            this.unit = value;
        } else if (key.equals("absmin")) {
            this.help.add((Object)(key + "=" + value));
        } else if (key.equals("min")) {
            this.help.add((Object)(key + "=" + value));
        } else if (key.equals("max")) {
            this.help.add((Object)(key + "=" + value));
        } else if (key.equals("absmax")) {
            this.help.add((Object)(key + "=" + value));
        }
    }

    public void setList(String key, StringList value) {
        if ((key = key.toLowerCase()).equals("values")) {
            this.labels = value;
        }
    }

    protected void post() {
        String ex;
        String n;
        if (this.fixeval != null) {
            this.init = null;
        }
        if ((n = this.headName(ex = this.fixeval)) == null) {
            return;
        }
        CFPar m = this.cf.par(n);
        if (m == null) {
            return;
        }
        if (m.type == 4) {
            return;
        }
        if (m.type == 2 && ex.length() > n.length() + 1) {
            try {
                int l = n.length();
                if (ex.charAt(l) == '+') {
                    ++l;
                }
                String b = ex.substring(l);
                m.labelBase = Util.toInt((String)b);
            }
            catch (Xcept e) {
                return;
            }
        } else if (!ex.equals(n)) {
            return;
        }
        m.loc = this.loc;
        this.skip = true;
    }

    private String headName(String s) {
        int i;
        if (s == null) {
            return null;
        }
        for (i = 0; i < s.length() && (s.charAt(i) == '_' || Character.isLetterOrDigit(s.charAt(i))); ++i) {
        }
        if (Util.isBlank((String)(s = s.substring(0, i)))) {
            return null;
        }
        return s;
    }

    public String name() {
        if (this.jsname != null) {
            return this.jsname;
        }
        return this.xsname;
    }

    public boolean dynamic() {
        switch (this.dynamic) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return !this.input;
    }

    public String eval() {
        if (this.fixeval != null) {
            return this.fixeval;
        }
        if (this.eval != null) {
            return this.eval;
        }
        return null;
    }

    public void writeMMLVar() {
        if (this.skip) {
            return;
        }
        String stype = null;
        switch (this.type) {
            case 1: 
            case 2: {
                stype = "choice";
                if (this.init == null) break;
                int inx = this.labels.indexOf(this.init);
                this.init = inx < 0 ? null : "" + (inx + 1 + this.labelBase);
                break;
            }
            case 3: {
                stype = "int";
                break;
            }
            case 4: {
                stype = "real";
                break;
            }
            case 5: {
                this.warn("STRING datatype not yet supported for parameter " + this.xsname);
                return;
            }
            default: {
                this.error("Unknown datatype for parameter " + this.xsname);
                return;
            }
        }
        String seqn = "";
        if (this.input) {
            stype = stype + "Input";
            if (this.init != null) {
                seqn = " = " + this.init;
            } else if (this.eval() == null) {
                stype = "extern " + stype;
                this.warn("Missing or invalid init or missing eval for parameter " + this.xsname);
            }
        } else {
            stype = stype + "Output";
        }
        String sunit = "";
        String scomment = "";
        if (!Util.isBlank((String)this.unit)) {
            try {
                System.setErr(this.nullErr);
                Unit.parse((NameSpace)this.cf.unitModel, (String)("1 " + this.unit));
                System.setErr(this.saveErr);
                sunit = " " + this.unit;
            }
            catch (Xcept e) {
                String unit1 = this.unit;
                unit1 = unit1.replaceAll("1/\\(Molar s\\)", "1/Molar/s");
                unit1 = unit1.replaceAll("none", "dimensionless");
                unit1 = unit1.replaceAll("no.units", "dimensionless");
                unit1 = unit1.replaceAll("seconds", "sec");
                unit1 = unit1.replaceAll("microsec", "usec");
                unit1 = unit1.replaceAll("amount/ml", "1/ml");
                unit1 = unit1.replaceAll(" ", "*");
                try {
                    Unit.parse((NameSpace)this.cf.unitModel, (String)("1 " + unit1));
                    System.setErr(this.saveErr);
                    sunit = " " + unit1;
                }
                catch (Xcept e1) {
                    System.setErr(this.saveErr);
                    this.warn("illegal unit <" + unit1 + "> for parameter " + this.xsname);
                    scomment = " // XSim units=\"" + this.unit + "\"";
                }
            }
        }
        String sargs = "";
        if (this.type == 2) {
            sargs = "(";
            if (this.labelBase != 0) {
                sargs = sargs + (this.labelBase + 1) + ",";
            }
            sargs = sargs + this.labels.toString(",", true) + ")";
        } else {
            StringList largs = new StringList(2);
            if (this.dynamic()) {
                largs.add((Object)this.cf.ivar.name());
            }
            if (this.dim1 > 1) {
                largs.add((Object)("x" + this.dim1));
            }
            if (largs.size() > 0) {
                sargs = "(" + largs.toString(",", false) + ")";
            }
        }
        if (this.loc == 0) {
            this.loc = this.cf.maxloc++;
        }
        String sdim = "";
        if (this.dim1 > 1) {
            sdim = " " + this.name() + ".dim=" + this.dim1 + ";";
        }
        String shelp = "";
        if (this.help.size() > 1) {
            shelp = " " + this.name() + ".help = \"" + this.help.toString("  ", false) + "\";";
        }
        this.println("\t" + stype + " " + this.name() + sargs + seqn + sunit + "; " + this.name() + ".loc=" + this.loc + ";" + sdim + shelp + scomment);
    }

    public void writeMMLEqn() {
        if (this.skip || !this.input) {
            return;
        }
        String s = this.eval();
        if (s == null) {
            return;
        }
        s = s.replaceAll("\\*\\*", "^");
        s = s.replaceAll("==", "=");
        while (s.indexOf("?") > 0) {
            int sx1 = s.indexOf(63);
            int sx2 = s.lastIndexOf(58);
            if (sx2 <= sx1) {
                this.warn("Malformed eval for parameter " + this.xsname + ": " + s);
                break;
            }
            s = "if (" + s.substring(0, sx1) + ") (" + s.substring(sx1 + 1, sx2) + ") else (" + s.substring(sx2 + 1, s.length()) + ")";
        }
        for (int i = 0; i < this.cf.renamedPars.size(); ++i) {
            CFPar p = (CFPar)this.cf.renamedPars.item(i);
            String s0 = p.xsname;
            s0 = s0.replaceAll("\\(", "\\\\(");
            s0 = s0.replaceAll("\\)", "\\\\)");
            s = s.replaceAll("'" + s0 + "'", p.jsname);
            s = s.replaceAll(s0, p.jsname);
        }
        this.println("\t" + this.name() + " = " + s + ";");
    }
}

