/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.aserver.ASModel;
import JSim.aserver.ASVar;
import JSim.project.Control;
import JSim.project.FuncGen;
import JSim.project.PModel;
import JSim.project.PNamed;
import JSim.project.Plot;
import JSim.project.PlotItem;
import JSim.project.PlotPage;
import JSim.project.Project;
import JSim.project.StringControl;
import JSim.util.DiagInfo;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.StringList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

public class XSParFile {
    private String fileName;
    private BufferedReader rdr;
    private int lineCt;
    private String currGroup;
    private Par.NList pars;
    private Par.NList mpars;
    private StringList feeds;
    private StringList report;

    public XSParFile(File f) throws Xcept {
        try {
            this.pars = this.readFile(f);
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
        this.updateSlaveValues(this.pars);
        this.mpars = this.makeModelPars(this.pars);
        this.feeds = this.makeFeeds();
        this.report = new StringList(32);
    }

    private Par.NList readFile(File f) throws Exception {
        Par par;
        this.fileName = f.getAbsolutePath();
        FileReader frdr = new FileReader(f);
        this.rdr = new BufferedReader(frdr);
        this.currGroup = null;
        Par.NList pars = new Par.NList(64);
        String line = this.getLine();
        if (line == null || !line.equals("xs01")) {
            throw new Xcept("First line of XSIM par file must be xs01");
        }
        while ((par = this.nextPar()) != null) {
            XSParFile.debug("--reading " + par.name() + "=" + par.value);
            pars.add(par);
        }
        return pars;
    }

    private Par nextPar() throws Exception {
        String word2;
        String word1;
        int ct;
        StringTokenizer stok;
        String line;
        while (true) {
            if ((line = this.getLine()) == null) {
                return null;
            }
            stok = new StringTokenizer(line = this.quotedSpacesToUnderbars(line));
            ct = stok.countTokens();
            if (ct < 2) continue;
            word1 = Util.stripQuotes((String)stok.nextToken());
            word2 = stok.nextToken();
            if (word2.equals("{")) {
                this.currGroup = this.currGroup == null ? word1 : this.currGroup + "." + word1;
                continue;
            }
            if (!word2.equals("}")) break;
            int inx = this.currGroup.lastIndexOf(46);
            this.currGroup = inx >= 0 ? this.currGroup.substring(0, inx) : null;
        }
        Par par = new Par(this.currGroup, word1, word2);
        if (ct >= 4) {
            stok.nextToken();
            par.value = this.getRemainingTokens(stok);
        } else {
            line = this.getLine();
            if (line == null) {
                return null;
            }
            stok = new StringTokenizer(line);
            par.value = this.getRemainingTokens(stok);
        }
        par.value = Util.stripQuotes((String)par.value);
        par.value = this.hackIfElse(par.value);
        return par;
    }

    private String getRemainingTokens(StringTokenizer stok) {
        String s = stok.nextToken();
        if (s == null) {
            return s;
        }
        while (stok.hasMoreTokens()) {
            s = s + " " + stok.nextToken();
        }
        return s;
    }

    private String getLine() throws Exception {
        char c;
        String s;
        int i;
        do {
            ++this.lineCt;
            s = this.rdr.readLine();
            if (s == null) {
                return s;
            }
            for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
            }
        } while (i >= s.length() || (c = s.charAt(i)) == '-' || c == '.' || Character.isDigit(c));
        return s;
    }

    private String hackIfElse(String s) {
        if (s == null) {
            return s;
        }
        int qinx = s.indexOf(63);
        int cinx = s.lastIndexOf(58);
        if (qinx < 0 || cinx < 0 || qinx >= cinx) {
            return s;
        }
        String a = s.substring(0, qinx - 1);
        String b = s.substring(qinx + 1, cinx);
        String c = s.substring(cinx + 1);
        if (Util.isBlank((String)a)) {
            return s;
        }
        if (Util.isBlank((String)b)) {
            return s;
        }
        if (Util.isBlank((String)c)) {
            return s;
        }
        s = "if (" + a.replace("==", "=") + ") (" + b + ") else (" + c + ")";
        return s;
    }

    private String quotedSpacesToUnderbars(String s) {
        StringBuffer buf = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 34) {
                boolean bl = quoted = !quoted;
            }
            if (c == 32 && quoted) {
                c = 95;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    private void readError(String msg) throws Xcept {
        throw new Xcept(msg + "; at line #" + this.lineCt + " of file " + this.fileName);
    }

    private void updateSlaveValues(Par.NList pars) throws Xcept {
        for (int i = 0; i < pars.size(); ++i) {
            Par pmaster;
            Par pslave;
            Par peval = pars.par(i);
            if (!peval.group.startsWith("model") || !peval.name.equals("eval") || (pslave = pars.par(peval.group + ".val")) == null) continue;
            XSParFile.debug(" slave=" + pslave.group + " val=" + pslave.value + " eval=" + peval.value);
            String nmaster = XSParFile.masterName(peval.value);
            if (nmaster == null || (pmaster = pars.par(nmaster = "model." + nmaster + ".val")) == null) continue;
            XSParFile.debug("  " + nmaster + ": " + pmaster.value + " <- " + pslave.value);
            pmaster.value = pslave.value;
        }
    }

    private static String masterName(String eval) {
        int n;
        if (Util.isBlank((String)eval)) {
            return null;
        }
        for (n = eval.length(); n > 0 && Character.isDigit(eval.charAt(n - 1)); --n) {
        }
        if (n == eval.length() || n < 2) {
            return null;
        }
        char op = eval.charAt(n - 1);
        if (op != '+' && op != '-') {
            return null;
        }
        return eval.substring(0, n - 1);
    }

    private static void debug(String s) {
    }

    private Par.NList makeModelPars(Par.NList pars) throws Xcept {
        Par.NList mpars = new Par.NList(64);
        for (int i = 0; i < pars.size(); ++i) {
            Par par = pars.par(i);
            if (!par.group.startsWith("model")) continue;
            String name = par.subgroup();
            name = this.badCharsToUnderbars(name);
            if (mpars.size() < 4) {
                name = this.replaceSfx(name, "_start", ".min");
                name = this.replaceSfx(name, "_stop", ".max");
                name = this.replaceSfx(name, "_incr", ".delta");
            }
            if (mpars.par(name) != null) continue;
            Par mpar = new Par("", name, "4");
            Par xpar = pars.par(par.group + "." + "val");
            if (xpar != null) {
                mpar.value = xpar.value;
            }
            if ((xpar = pars.par(par.group + "." + "eval")) != null) {
                mpar.value = xpar.value;
            }
            mpars.add(mpar);
        }
        return mpars;
    }

    private String replaceSfx(String s, String sfx1, String sfx2) {
        int l1;
        int l = s.length();
        if (l < (l1 = sfx1.length()) + 1) {
            return s;
        }
        String send = s.substring(l - l1);
        if (sfx1.equals(send)) {
            return s.substring(0, l - l1) + sfx2;
        }
        return s;
    }

    private String badCharsToUnderbars(String s) {
        StringBuffer buf = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                c = '_';
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public StringList makeFeeds() throws Xcept {
        StringList feeds = new StringList(32);
        for (int i = 0; i < this.mpars.size(); ++i) {
            Par mpar = this.mpars.par(i);
            String name = mpar.name;
            if (!name.endsWith("_p1tbegn")) continue;
            int ct = name.length();
            String s = name.substring(0, ct - 8);
            feeds.addUniq(s);
        }
        return feeds;
    }

    public void assignModelPars(PModel pmodel) throws Xcept {
        this.report = new StringList(32);
        this.report.add((Object)("Imported " + this.fileName + " into model " + pmodel.name()));
        StringList missingPars = new StringList(16);
        StringList setPars = new StringList(16);
        ASModel rt = pmodel.rt();
        for (int i = 0; i < this.mpars.size(); ++i) {
            Par mpar = this.mpars.par(i);
            String name = mpar.name;
            String val = mpar.value;
            String skip = null;
            ASVar v = null;
            try {
                v = rt.getASVar(name);
            }
            catch (Xcept e) {
                // empty catch block
            }
            if (val == null) {
                skip = "null value";
            } else if (name.startsWith("solflg__")) {
                skip = "solver";
            } else if (val.equals(name + "_sw-1")) {
                skip = "switch";
            } else if (val.equals(name + "_int")) {
                skip = "switch";
            }
            for (int j = 0; j < this.feeds.size(); ++j) {
                String fname = this.feeds.str(j);
                if (!name.startsWith(fname + "_")) continue;
                skip = "feed";
            }
            if (v != null && !v.isInput()) {
                skip = "output";
            }
            if (name.indexOf(58) >= 0) {
                skip = "derivative";
            }
            if (v == null && skip == null) {
                missingPars.add((Object)name);
                continue;
            }
            if (skip != null) continue;
            StringControl cntl = (StringControl)pmodel.vars().control(name);
            cntl.setVal(val);
            if (!cntl.valid()) {
                this.report.add((Object)("    Invalid parameter assignment: " + name + "=" + val));
            }
            setPars.add((Object)name);
        }
        ASVar.List asvars = rt.getASVars();
        StringList unsetPars = new StringList(16);
        for (int i = 0; i < asvars.size(); ++i) {
            String n;
            ASVar v = asvars.asvar(i);
            if (!v.isInput() || setPars.containSame(n = v.name()) || this.feeds.containSame(n)) continue;
            unsetPars.add((Object)v.name());
        }
        this.report.add((Object)("    Feed parameters not imported: " + (this.feeds.size() == 0 ? "none" : this.feeds.toString())));
        this.report.add((Object)("    Model parameters missing from file: " + (unsetPars.size() == 0 ? "none" : unsetPars.toString())));
    }

    public void assignFgen(FuncGen f, String pbase) throws Xcept {
        this.setCntl((PNamed)f, "which", pbase + "fselect.val", new String[]{"1", "Pulse1", "2", "Pulse2", "3", "Pulse3", "4", "Sine", "5", "Sawtooth", "7", "LagNormal", "8", "GammaVar", "9", "Poisson", "10", "Gaussian", "11", "Exponential", "12", "RandomWalk"});
        this.setCntl((PNamed)f, "Pulse1.startTime", pbase + "p1tbegn.val");
        this.setCntl((PNamed)f, "Pulse1.duration", pbase + "p1tdur.val");
        this.setCntl((PNamed)f, "Pulse1.amplitude", pbase + "p1amp.val");
        this.setCntl((PNamed)f, "Exponential.area", pbase + "dfarea.val");
        this.setCntl((PNamed)f, "Exponential.tMean", pbase + "dfmean.val");
        this.setCntl((PNamed)f, "Exponential.rd", pbase + "dfrd.val");
        this.setCntl((PNamed)f, "Gaussian.area", pbase + "dfarea.val");
        this.setCntl((PNamed)f, "Gaussian.tMean", pbase + "dfmean.val");
        this.setCntl((PNamed)f, "Gaussian.rd", pbase + "dfrd.val");
        this.setCntl((PNamed)f, "LagNormal.area", pbase + "dfarea.val");
        this.setCntl((PNamed)f, "LagNormal.tMean", pbase + "dfmean.val");
        this.setCntl((PNamed)f, "LagNormal.rd", pbase + "dfrd.val");
        this.setCntl((PNamed)f, "LagNormal.skewn", pbase + "dfskew.val");
        this.setCntl((PNamed)f, "LagNormal.frPeak", pbase + "dffrpeak.val");
        this.setCntl((PNamed)f, "GammaVar.area", pbase + "dfarea.val");
        this.setCntl((PNamed)f, "GammaVar.tMean", pbase + "dfmean.val");
        this.setCntl((PNamed)f, "GammaVar.rd", pbase + "dfrd.val");
        this.setCntl((PNamed)f, "GammaVar.skewn", pbase + "dfskew.val");
        this.setCntl((PNamed)f, "GammaVar.frPeak", pbase + "dffrpeak.val");
        this.setCntl((PNamed)f, "Poisson.area", pbase + "dfarea.val");
        this.setCntl((PNamed)f, "Poisson.tMean", pbase + "dfmean.val");
        this.setCntl((PNamed)f, "Poisson.rd", pbase + "dfrd.val");
        this.setCntl((PNamed)f, "Poisson.frPeak", pbase + "dffrpeak.val");
        this.setCntl((PNamed)f, "RandomWalk.area", pbase + "dfarea.val");
        this.setCntl((PNamed)f, "RandomWalk.tMean", pbase + "dfmean.val");
        this.setCntl((PNamed)f, "RandomWalk.rd", pbase + "dfrd.val");
        this.setCntl((PNamed)f, "RandomWalk.skewn", pbase + "dfskew.val");
        this.setCntl((PNamed)f, "RandomWalk.frPeak", pbase + "dffrpeak.val");
    }

    public void addPlotPage(PModel pmodel, String pbase, String pname) throws Xcept {
        Project proj = pmodel.project();
        PlotPage page = new PlotPage((PNamed)proj, pname);
        Plot plot = page.plot(0);
        int j = 0;
        for (int i = 0; i < 9; ++i) {
            String sfx = i == 0 ? "" : "" + (i + 1);
            String ydesc = this.parVal(pbase + "ydesc" + sfx);
            if (ydesc == null) continue;
            plot.nItems.setVal(j + 1);
            PlotItem item = plot.item(j++);
            item.expr.setVal(ydesc);
            item.dataSrc.setVal(pmodel.name());
            this.setCntl((PNamed)item, "xExpr", pbase + "xdesc");
            this.setCntl((PNamed)item, "color", pbase + "ycolor" + sfx, new String[]{"1", "black", "2", "gray", "3", "salmon", "4", "violet", "5", "brown", "6", "red", "7", "forest", "8", "blue"});
            this.setCntl((PNamed)item, "size", pbase + "ysize" + sfx, new String[]{"1", "small", "2", "normal", "3", "big"});
            item.line.setVal("none");
        }
        this.setCntl((PNamed)plot, "xaxis.min", pbase + "xmin");
        this.setCntl((PNamed)plot, "xaxis.max", pbase + "xmax");
        this.setCntl((PNamed)plot, "xaxis.autoscale", pbase + "xauto");
        this.setCntl((PNamed)plot, "xaxis.log", pbase + "xlinear", new String[]{"true", "linear", "false", "log"});
        this.setCntl((PNamed)plot, "yaxis.min", pbase + "ymin");
        this.setCntl((PNamed)plot, "yaxis.max", pbase + "ymax");
        this.setCntl((PNamed)plot, "yaxis.autoscale", pbase + "yauto");
        this.setCntl((PNamed)plot, "yaxis.log", pbase + "ylinear", new String[]{"true", "linear", "false", "log"});
    }

    public String parVal(String n) {
        Par par = this.pars.par(n);
        if (par == null) {
            return null;
        }
        String v = par.value();
        if (Util.isBlank((String)v)) {
            return null;
        }
        return v;
    }

    public void setCntl(PNamed base, String child, String parname) throws Xcept {
        this.setCntl(base, child, parname, null);
    }

    public void setCntl(PNamed base, String child, String parname, String[] subs) throws Xcept {
        Control cntl = (Control)base.nestedChild(child);
        if (cntl == null) {
            throw new Xcept((DiagInfo)base, child + " unknown");
        }
        String v = this.parVal(parname);
        if (v == null) {
            return;
        }
        if (subs == null) {
            cntl.setVal(v);
            return;
        }
        for (int i = 0; i < subs.length; i += 2) {
            if (!v.equals(subs[i])) continue;
            cntl.setVal(subs[i + 1]);
            return;
        }
        this.report.add((Object)("  parm " + parname + "=" + v + " not translatable to JSim"));
    }

    public Par.NList pars() {
        return this.pars;
    }

    public Par.NList mpars() {
        return this.mpars;
    }

    public StringList report() {
        return this.report;
    }

    public static void main(String[] args) {
        System.out.println("" + XSParFile.masterName(args[0]));
    }

    public static class Par
    implements Named {
        public String group;
        public String name;
        public int type;
        public String value;

        public Par(String g, String n, String t) throws Xcept {
            this.group = g;
            this.name = n;
            this.type = Util.toInt((String)t);
        }

        public String name() {
            return this.group + "." + this.name;
        }

        public String diagInfo() {
            return "XSPar " + this.name();
        }

        public double realVal() {
            return Util.toDouble((String)this.value);
        }

        public boolean boolVal() {
            if (this.value.equalsIgnoreCase("f")) {
                return false;
            }
            if (this.value.equalsIgnoreCase("false")) {
                return false;
            }
            return !this.value.equals("0");
        }

        public String subgroup() {
            int inx = this.group.lastIndexOf(46) + 1;
            if (inx < 0 || inx >= this.group.length()) {
                return "";
            }
            return this.group.substring(inx);
        }

        public String value() {
            if (this.type != 1) {
                return this.value;
            }
            return this.boolVal() ? "true" : "false";
        }

        public static class NList
        extends NamedList {
            public NList(int i) {
                super(i);
            }

            public Par par(int i) {
                return (Par)this.get(i);
            }

            public Par par(String n) {
                return (Par)this.getByName(n);
            }

            public void dump() {
                for (int i = 0; i < this.size(); ++i) {
                    Par par = this.par(i);
                    XSParFile.debug(par.name() + "=" + par.value());
                }
            }
        }
    }
}

