/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.KineticLaw;
import jigcell.sbml2.ModifierSpeciesReference;
import jigcell.sbml2.SBase;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.SimpleSpeciesReference;
import jigcell.sbml2.Species;
import jigcell.sbml2.SpeciesReference;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class Reaction
extends SBaseId {
    private Boolean fast;
    private boolean reversible;
    private KineticLaw kineticLaw;
    private final List modifier;
    private final List product;
    private final List reactant;
    private final SBase modifiersElement;
    private final SBase productsElement;
    private final SBase reactantsElement;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Reaction() {
        this(null, null);
    }

    public Reaction(Reaction reaction) {
        this(reaction.getId(), reaction.isNameSet() ? reaction.getName() : null);
        SimpleSpeciesReference reference;
        if (reaction.isFastSet()) {
            this.setFast(reaction.isFast());
        }
        this.setReversible(reaction.isReversible());
        if (reaction.getKineticLaw() != null) {
            this.setKineticLaw(new KineticLaw(reaction.getKineticLaw()));
        }
        Iterator iterator = reaction.getModifier().iterator();
        while (iterator.hasNext()) {
            reference = (ModifierSpeciesReference)iterator.next();
            if (reference == null) continue;
            this.addModifier(new ModifierSpeciesReference((ModifierSpeciesReference)reference));
        }
        iterator = reaction.getProduct().iterator();
        while (iterator.hasNext()) {
            reference = (SpeciesReference)iterator.next();
            if (reference == null) continue;
            this.addProduct(new SpeciesReference((SpeciesReference)reference));
        }
        iterator = reaction.getReactant().iterator();
        while (iterator.hasNext()) {
            reference = (SpeciesReference)iterator.next();
            if (reference == null) continue;
            this.addReactant(new SpeciesReference((SpeciesReference)reference));
        }
    }

    public Reaction(String id, String name) {
        super(id, name);
        this.setReversible(true);
        this.unsetFast();
        this.modifier = new ArrayList();
        this.modifiersElement = new SBase();
        this.product = new ArrayList();
        this.productsElement = new SBase();
        this.reactant = new ArrayList();
        this.reactantsElement = new SBase();
    }

    public void addModifier(Species reference) {
        this.addModifier(new ModifierSpeciesReference(reference));
    }

    public void addModifier(ModifierSpeciesReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        this.modifier.add(reference);
    }

    public void addProduct(Species reference) {
        this.addProduct(new SpeciesReference(reference));
    }

    public void addProduct(SpeciesReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        this.product.add(reference);
    }

    public void addReactant(Species reference) {
        this.addReactant(new SpeciesReference(reference));
    }

    public void addReactant(SpeciesReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        this.reactant.add(reference);
    }

    public KineticLaw getKineticLaw() {
        return this.kineticLaw;
    }

    public List getModifier() {
        return this.modifier;
    }

    public SBase getModifiersElement() {
        return this.modifiersElement;
    }

    public List getProduct() {
        return this.product;
    }

    public SBase getProductsElement() {
        return this.productsElement;
    }

    public List getReactant() {
        return this.reactant;
    }

    public SBase getReactantsElement() {
        return this.reactantsElement;
    }

    public boolean isFast() {
        if (!$assertionsDisabled && !this.isFastSet()) {
            throw new AssertionError();
        }
        return this.isFastSet() && this.fast != false;
    }

    public boolean isFastSet() {
        return this.fast != null;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setFast(boolean fast) {
        this.fast = fast ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setKineticLaw(KineticLaw kineticLaw) {
        this.kineticLaw = kineticLaw;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public void unsetFast() {
        this.fast = null;
    }

    protected void parse(Attributes attributes) {
        super.parse(attributes);
        if (attributes.getIndex("fast") != -1) {
            this.setFast(Boolean.valueOf(attributes.getValue("fast")) == Boolean.TRUE);
        }
        if (attributes.getIndex("reversible") != -1) {
            this.setReversible(Boolean.valueOf(attributes.getValue("reversible")) == Boolean.TRUE);
        }
    }

    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "reaction");
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        if (!this.isReversible()) {
            printer.addAttribute("reversible", "false");
        }
        if (this.isFastSet()) {
            printer.addAttribute("fast", this.isFast() ? "true" : "false");
        }
        printer.addElementList(this.getReactantsElement(), "listOfReactants", this.getReactant());
        printer.addElementList(this.getProductsElement(), "listOfProducts", this.getProduct());
        printer.addElementList(this.getModifiersElement(), "listOfModifiers", this.getModifier());
        printer.addElement(this.getKineticLaw());
        return printer;
    }

    static {
        $assertionsDisabled = !Reaction.class.desiredAssertionStatus();
    }
}

