/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.Annotations;
import jigcell.sbml2.Model;
import jigcell.sbml2.Notes;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.XMLElement;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public class SBase
extends XMLElement {
    private final Annotations annotations = new Annotations();
    private final Notes notes = new Notes();
    private String metaid;
    private String rdf;

    static final SBaseId searchListForId(List elements, String id) {
        if (id == null) {
            return null;
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            SBaseId element = (SBaseId)iterator.next();
            if (!id.equals(element.getId())) continue;
            return element;
        }
        return null;
    }

    static final SBaseId searchListForName(List elements, String name) {
        if (name == null) {
            return null;
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            SBaseId element = (SBaseId)iterator.next();
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public final Annotations getAnnotations() {
        return this.annotations;
    }

    public final String getMetaid() {
        return this.metaid;
    }

    public final Notes getNotes() {
        return this.notes;
    }

    public final String getRDF() {
        return this.rdf;
    }

    public boolean isValid(Model model) {
        return true;
    }

    public final void setMetaid(String metaid) {
        this.metaid = metaid;
    }

    public final void setRDF(String rdf) {
        this.rdf = rdf;
    }

    public final void setRDF(String rdf, String metaid) {
        this.setRDF(rdf);
        this.setMetaid(metaid);
    }

    protected SBase() {
    }

    protected void parse(Attributes attributes) {
        this.setMetaid(attributes.getValue("metaid"));
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        String rdfText;
        String annotationsText;
        XMLPrinter printer = super.print(parent, name);
        String notesText = this.getNotes().toString().trim();
        if (notesText.length() > 0) {
            printer.addText(notesText);
        }
        if ((annotationsText = this.getAnnotations().toString().trim()).length() > 0) {
            printer.addText(annotationsText);
        }
        if ((rdfText = this.getRDF()) != null && (rdfText = rdfText.trim()).length() > 0) {
            printer.addText(rdfText);
        }
        printer.addAttribute("metaid", this.getMetaid());
        return printer;
    }
}

