/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.Iterator;
import jigcell.sbml2.Compartment;
import jigcell.sbml2.Event;
import jigcell.sbml2.EventAssignment;
import jigcell.sbml2.Model;
import jigcell.sbml2.Rule;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.VariableRule;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class Species
extends SBaseId {
    private boolean boundaryCondition;
    private boolean constant;
    private boolean hasOnlySubstanceUnits;
    private double initialAmount;
    private double initialConcentration;
    private Integer charge;
    private String compartment;
    private String spatialSizeUnits;
    private String substanceUnits;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Species() {
        this(null, null);
    }

    public Species(Species species) {
        this(species.getId(), species.isNameSet() ? species.getName() : null);
        this.setBoundaryCondition(species.isBoundaryCondition());
        this.setConstant(species.isConstant());
        this.setHasOnlySubstanceUnits(species.getHasOnlySubstanceUnits());
        this.setInitialAmount(species.getInitialAmount());
        this.setInitialConcentration(species.getInitialConcentration());
        if (species.isChargeSet()) {
            this.setCharge(species.getCharge());
        }
        this.setCompartment(species.getCompartment());
        this.setSpatialSizeUnits(species.getSpatialSizeUnits());
        this.setSubstanceUnits(species.getSubstanceUnits());
    }

    public Species(String id, String name) {
        super(id, name);
        this.setInitialAmount(Double.NaN);
        this.setInitialConcentration(Double.NaN);
        this.setBoundaryCondition(false);
        this.setConstant(false);
        this.setHasOnlySubstanceUnits(false);
        this.unsetCharge();
    }

    public int getCharge() {
        if (!$assertionsDisabled && !this.isChargeSet()) {
            throw new AssertionError();
        }
        return this.isChargeSet() ? this.charge : 0;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public Compartment getCompartment(Model model) {
        return (Compartment)model.findElementWithId(this.getCompartment(), 1);
    }

    public boolean getHasOnlySubstanceUnits() {
        return this.hasOnlySubstanceUnits;
    }

    public double getInitialAmount() {
        return this.initialAmount;
    }

    public double getInitialConcentration() {
        return this.getHasOnlySubstanceUnits() ? Double.NaN : this.initialConcentration;
    }

    public String getSpatialSizeUnits() {
        return this.spatialSizeUnits;
    }

    public UnitDefinition getSpatialSizeUnits(Model model) {
        UnitDefinition units = (UnitDefinition)model.findElementWithId(this.getSpatialSizeUnits(), 64);
        if (units != null) {
            return units;
        }
        Compartment compartment = this.getCompartment(model);
        return compartment == null ? null : compartment.getUnits(model);
    }

    public String getSubstanceUnits() {
        return this.substanceUnits == null ? "substance" : this.substanceUnits;
    }

    public UnitDefinition getSubstanceUnits(Model model) {
        return (UnitDefinition)model.findElementWithId(this.getSubstanceUnits(), 64);
    }

    public boolean isBoundaryCondition() {
        return this.boundaryCondition;
    }

    public boolean isChargeSet() {
        return this.charge != null;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public boolean isSetByEvent(Model model) {
        String id = this.getId();
        if (id == null) {
            return false;
        }
        Iterator eventIterator = model.getEvents().iterator();
        while (eventIterator.hasNext()) {
            Iterator assignmentIterator = ((Event)eventIterator.next()).getEventAssignment().iterator();
            while (assignmentIterator.hasNext()) {
                if (!id.equals(((EventAssignment)assignmentIterator.next()).getVariable())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSetByRule(Model model) {
        String id = this.getId();
        if (id == null) {
            return false;
        }
        Iterator iterator = model.getRules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!(rule instanceof VariableRule) || !id.equals(((VariableRule)rule).getVariable())) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(Model model) {
        if (!super.isValid(model) || !UnitDefinition.isValidSubstanceUnit(this.getSubstanceUnits(model)) || this.getCompartment(model) == null) {
            return false;
        }
        Compartment compartment = this.getCompartment(model);
        if (compartment == null) {
            return false;
        }
        int dimensions = compartment.getSpatialDimensions();
        if (!UnitDefinition.isValidSpatialSizeUnit(this.getSpatialSizeUnits(model), dimensions)) {
            return false;
        }
        return dimensions != 0 || Double.isNaN(this.getInitialConcentration());
    }

    public void setBoundaryCondition(boolean boundaryCondition) {
        this.boundaryCondition = boundaryCondition;
    }

    public void setCharge(int charge) {
        this.charge = new Integer(charge);
    }

    public void setCompartment(String compartment) {
        if (compartment != null && !Species.isValidId(compartment)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.compartment = compartment;
    }

    public void setCompartment(Compartment compartment) {
        this.setCompartment(compartment == null ? null : compartment.getId());
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public void setHasOnlySubstanceUnits(boolean hasOnlySubstanceUnits) {
        this.hasOnlySubstanceUnits = hasOnlySubstanceUnits;
    }

    public void setInitialAmount(double initialAmount) {
        this.initialAmount = initialAmount;
        if (!Double.isNaN(initialAmount)) {
            this.setInitialConcentration(Double.NaN);
        }
    }

    public void setInitialConcentration(double initialConcentration) {
        this.initialConcentration = initialConcentration;
        if (!Double.isNaN(initialConcentration)) {
            this.setInitialAmount(Double.NaN);
        }
    }

    public void setSpatialSizeUnits(String spatialSizeUnits) {
        if (spatialSizeUnits != null && !Species.isValidId(spatialSizeUnits)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.spatialSizeUnits = spatialSizeUnits;
    }

    public void setSpatialSizeUnits(UnitDefinition units) {
        this.setSpatialSizeUnits(units == null ? null : units.getId());
    }

    public void setSubstanceUnits(String substanceUnits) {
        if (substanceUnits != null && !Species.isValidId(substanceUnits)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.substanceUnits = substanceUnits;
    }

    public void setSubstanceUnits(UnitDefinition units) {
        this.setSubstanceUnits(units == null ? null : units.getId());
    }

    public void unsetCharge() {
        this.charge = null;
    }

    protected void parse(Attributes attributes) {
        super.parse(attributes);
        if (attributes.getIndex("boundaryCondition") != -1) {
            this.setBoundaryCondition(Boolean.valueOf(attributes.getValue("boundaryCondition")) == Boolean.TRUE);
        }
        if (attributes.getIndex("charge") != -1) {
            this.setCharge(Integer.parseInt(attributes.getValue("charge")));
        }
        this.setCompartment(attributes.getValue("compartment"));
        if (attributes.getIndex("constant") != -1) {
            this.setConstant(Boolean.valueOf(attributes.getValue("constant")) == Boolean.TRUE);
        }
        if (attributes.getIndex("hasOnlySubstanceUnits") != -1) {
            this.setHasOnlySubstanceUnits(Boolean.valueOf(attributes.getValue("hasOnlySubstanceUnits")) == Boolean.TRUE);
        }
        if (attributes.getIndex("initialAmount") != -1) {
            this.setInitialAmount(Double.parseDouble(attributes.getValue("initialAmount")));
        }
        if (attributes.getIndex("initialConcentration") != -1) {
            this.setInitialConcentration(Double.parseDouble(attributes.getValue("initialConcentration")));
        }
        this.setSpatialSizeUnits(attributes.getValue("spatialSizeUnits"));
        this.setSubstanceUnits(attributes.getValue("substanceUnits"));
    }

    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "species");
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addAttribute("compartment", this.getCompartment());
        if (!Double.isNaN(this.getInitialAmount())) {
            printer.addAttribute("initialAmount", String.valueOf(this.getInitialAmount()));
        }
        if (!Double.isNaN(this.getInitialConcentration())) {
            printer.addAttribute("initialConcentration", String.valueOf(this.getInitialConcentration()));
        }
        if (this.isBoundaryCondition()) {
            printer.addAttribute("boundaryCondition", "true");
        }
        if (this.isChargeSet()) {
            printer.addAttribute("charge", String.valueOf(this.getCharge()));
        }
        if (this.isConstant()) {
            printer.addAttribute("constant", "true");
        }
        if (this.getHasOnlySubstanceUnits()) {
            printer.addAttribute("hasOnlySubstanceUnits", "true");
        }
        printer.addAttribute("spatialSizeUnits", this.getSpatialSizeUnits());
        if (!this.getSubstanceUnits().equals("substance")) {
            printer.addAttribute("substanceUnits", this.getSubstanceUnits());
        }
        return printer;
    }

    static {
        $assertionsDisabled = !Species.class.desiredAssertionStatus();
    }
}

